/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.particles.commands.XParticle;
import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.CommmandThatRunsCommand;
import com.ssomar.score.commands.runnable.SCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.configs.messages.Message;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobAround
extends MixedCommand
implements FeatureParentInterface {
    public MobAround() {
        CommandSetting distance = new CommandSetting("distance", 0, Double.class, (Object)3.0);
        CommandSetting displayMsgIfNoPlayer = new CommandSetting(Arrays.asList("displayMsgIfNoEntity", "DisplayMsgIfNoEntity"), -1, Boolean.class, (Object)true, true);
        CommandSetting throughBlocks = new CommandSetting("throughBlocks", -1, Boolean.class, (Object)true);
        CommandSetting safeDistance = new CommandSetting("safeDistance", -1, Double.class, (Object)0.0);
        CommandSetting offsetYaw = new CommandSetting("offsetYaw", -1, Double.class, (Object)0.0);
        CommandSetting offsetPitch = new CommandSetting("offsetPitch", -1, Double.class, (Object)0.0);
        CommandSetting offsetDistance = new CommandSetting("offsetDistance", -1, Double.class, (Object)0.0);
        CommandSetting limit = new CommandSetting("limit", -1, Integer.class, (Object)-1);
        CommandSetting sort = new CommandSetting("sort", -1, String.class, (Object)"NEAREST");
        List<CommandSetting> settings = this.getSettings();
        settings.add(distance);
        settings.add(displayMsgIfNoPlayer);
        settings.add(throughBlocks);
        settings.add(safeDistance);
        settings.add(offsetYaw);
        settings.add(offsetPitch);
        settings.add(offsetDistance);
        settings.add(limit);
        settings.add(sort);
        this.setNewSettingsMode(true);
        this.setCanExecuteCommands(true);
    }

    public static void mobAroundExecution(final Location location, @Nullable Entity launcher, final @Nullable Entity receiver, final boolean displayMsgIfNoEntity, final SCommandToExec sCommandToExec) {
        if (launcher != null) {
            sCommandToExec.getActionInfo().setLauncherUUID(launcher.getUniqueId());
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean hit;
                    Location receiverLoc;
                    double distance = (Double)sCommandToExec.getSettingValue("distance");
                    boolean throughBlocks = (Boolean)sCommandToExec.getSettingValue("throughBlocks");
                    double safeDistance = (Double)sCommandToExec.getSettingValue("safeDistance");
                    double offsetYaw = (Double)sCommandToExec.getSettingValue("offsetYaw");
                    double offsetPitch = (Double)sCommandToExec.getSettingValue("offsetPitch");
                    double offsetDistance = (Double)sCommandToExec.getSettingValue("offsetDistance");
                    int limit = (Integer)sCommandToExec.getSettingValue("limit");
                    String sort = (String)sCommandToExec.getSettingValue("sort");
                    Vector offset = XParticle.calculDirection(offsetYaw, offsetPitch).multiply(offsetDistance);
                    boolean startForCommand = true;
                    List<LivingEntity> entities = new ArrayList();
                    Location location2 = receiverLoc = receiver != null ? receiver.getLocation() : location;
                    if (receiver != null) {
                        receiverLoc = receiver.getLocation().add(offset);
                    }
                    Location finalReceiverLoc = receiverLoc;
                    for (Entity e : receiverLoc.getWorld().getNearbyEntities(receiverLoc, distance, distance, distance)) {
                        Location targetLoc;
                        if (!(e instanceof LivingEntity) || e instanceof Player || e.hasMetadata("NPC") || e.equals((Object)receiver)) continue;
                        LivingEntity target = (LivingEntity)e;
                        if (safeDistance > 0.0 && receiverLoc.distance(targetLoc = target.getLocation()) <= safeDistance) continue;
                        if (!throughBlocks) {
                            if (receiver instanceof LivingEntity) {
                                receiverLoc = ((LivingEntity)receiver).getEyeLocation();
                            }
                            ArrayList<Location> toCheck = new ArrayList<Location>();
                            toCheck.add(target.getLocation());
                            toCheck.add(target.getEyeLocation());
                            toCheck.add(target.getLocation().add(0.0, 1.0, 0.0));
                            boolean valid = false;
                            for (Location loc : toCheck) {
                                double distanceBetween = receiverLoc.distance(loc);
                                Vector direction = loc.toVector().subtract(receiverLoc.toVector()).normalize();
                                RayTraceResult rayTraceResult = receiverLoc.getWorld().rayTraceBlocks(receiverLoc, direction, distanceBetween, FluidCollisionMode.NEVER, true);
                                if (rayTraceResult != null) continue;
                                valid = true;
                                break;
                            }
                            if (!valid) continue;
                        }
                        if (target.hasMetadata("NPC") || target.equals((Object)receiver)) continue;
                        entities.add(target);
                    }
                    if (sort.equalsIgnoreCase("NEAREST")) {
                        entities.sort((e1, e2) -> {
                            double d1 = e1.getLocation().distance(finalReceiverLoc);
                            double d2 = e2.getLocation().distance(finalReceiverLoc);
                            return Double.compare(d1, d2);
                        });
                    } else if (sort.equalsIgnoreCase("RANDOM")) {
                        Collections.shuffle(entities);
                    }
                    if (limit > 0 && entities.size() > limit) {
                        entities = entities.subList(0, limit);
                    }
                    if (!(hit = CommmandThatRunsCommand.runEntityCommands(entities, sCommandToExec.getOtherArgs(), sCommandToExec.getActionInfo())) && displayMsgIfNoEntity && receiver instanceof Player) {
                        SCommand.sm.sendMessage((CommandSender)receiver, MessageMain.getInstance().getMessage((Plugin)SCore.plugin, Message.NO_ENTITY_HIT));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        SCore.schedulerHook.runLocationTask(runnable, receiver != null ? receiver.getLocation() : location, 0L);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        MobAround.mobAroundExecution(null, (Entity)p, (Entity)receiver, (Boolean)sCommandToExec.getSettingValue("displayMsgIfNoEntity"), sCommandToExec);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("MOB_AROUND");
        return names;
    }

    @Override
    public String getTemplate() {
        return "MOB_AROUND distance:3 displayMsgIfNoEntity:true throughBlocks:true safeDistance:0 [conditions] COMMAND1 <+> COMMAND2 <+> ...";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return null;
    }

    @Override
    public FeatureInterface getFeature(FeatureSettingsInterface featureSettings) {
        return null;
    }

    @Override
    public FeatureInterface getFeatureWithName(String featureName) {
        return null;
    }

    @Override
    public String getParentInfo() {
        return "MOB_AROUND Command";
    }

    @Override
    @Nullable
    public FeatureParentInterface getParent() {
        return null;
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return null;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public void reload() {
    }

    @Override
    public void openEditor(@NotNull Player player) {
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
    }

    @Override
    public void save() {
    }

    @Override
    public boolean isPremium() {
        return false;
    }

    @Override
    public FeatureSettingsInterface getFeatureSettings() {
        return null;
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        return new ArrayList<String>();
    }

    @Override
    public void save(ConfigurationSection config) {
    }

    @Override
    public void writeInFile(ConfigurationSection config) {
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getEditorName() {
        return "";
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public FeatureInterface initItemParentEditor(GUI gui, int slot) {
        return null;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public void initAndUpdateItemParentEditor(GUI gui, int slot) {
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return false;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isRequirePremium() {
        return false;
    }

    @Override
    public FeatureInterface clone(FeatureParentInterface newParent) {
        return null;
    }

    @Override
    public void run(Player p, Entity entity, SCommandToExec sCommandToExec) {
        MobAround.mobAroundExecution(null, (Entity)p, entity, false, sCommandToExec);
    }
}

