/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class JobsXpBoost
extends PlayerCommand {
    private static JobsXpBoost instance;
    private final Map<UUID, List<Double>> activeBoosts = new HashMap<UUID, List<Double>>();

    public JobsXpBoost() {
        CommandSetting multiplier = new CommandSetting("multiplier", 0, Double.class, (Object)2.0);
        CommandSetting time = new CommandSetting("time", 1, Integer.class, (Object)10);
        List<CommandSetting> settings = this.getSettings();
        settings.add(multiplier);
        settings.add(time);
        this.setNewSettingsMode(true);
    }

    public static JobsXpBoost getInstance() {
        if (instance == null) {
            instance = new JobsXpBoost();
        }
        return instance;
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        final double multiplier = (Double)sCommandToExec.getSettingValue("multiplier");
        int time = (Integer)sCommandToExec.getSettingValue("time");
        final UUID uuid = receiver.getUniqueId();
        if (this.activeBoosts.containsKey(uuid)) {
            this.activeBoosts.get(uuid).add(multiplier);
        } else {
            this.activeBoosts.put(uuid, new ArrayList<Double>(Collections.singletonList(multiplier)));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (JobsXpBoost.this.activeBoosts.containsKey(uuid)) {
                    if (((List)JobsXpBoost.this.activeBoosts.get(uuid)).size() > 1) {
                        ((List)JobsXpBoost.this.activeBoosts.get(uuid)).remove(multiplier);
                    } else {
                        JobsXpBoost.this.activeBoosts.remove(uuid);
                    }
                }
            }
        };
        SCore.schedulerHook.runTask(runnable, (long)time * 20L);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("JOBS_XP_BOOST");
        return names;
    }

    @Override
    public String getTemplate() {
        return "JOBS_XP_BOOST multiplier:2.0 time:10";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }

    @Generated
    public Map<UUID, List<Double>> getActiveBoosts() {
        return this.activeBoosts;
    }
}

