/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.block.condition;

import com.ssomar.executableblocks.api.ExecutableBlocksAPI;
import com.ssomar.executableblocks.executableblocks.placedblocks.ExecutableBlockPlaced;
import com.ssomar.executableblocks.executableblocks.placedblocks.LocationConverter;
import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.block.BlockConditionFeature;
import com.ssomar.score.features.custom.conditions.block.BlockConditionRequest;
import com.ssomar.score.features.types.NumberConditionFeature;
import com.ssomar.score.utils.strings.StringCalculation;
import java.util.Optional;
import org.bukkit.Location;

public class IfUsage
extends BlockConditionFeature<NumberConditionFeature, IfUsage> {
    public IfUsage(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifUsage);
    }

    @Override
    public boolean hasCondition() {
        return ((Optional)((NumberConditionFeature)this.getCondition()).getValue()).isPresent();
    }

    @Override
    public boolean verifCondition(BlockConditionRequest request) {
        if (this.hasCondition() && SCore.hasExecutableBlocks) {
            Location bLoc = LocationConverter.convert((Location)request.getBlock().getLocation(), (boolean)false, (boolean)false);
            Optional eBPOpt = ExecutableBlocksAPI.getExecutableBlocksPlacedManager().getExecutableBlockPlaced(bLoc);
            if (eBPOpt.isPresent()) {
                ExecutableBlockPlaced eBP = (ExecutableBlockPlaced)eBPOpt.get();
                int usage = eBP.getUsage();
                if (!StringCalculation.calculation(((NumberConditionFeature)this.getCondition()).getValue(request.getPlayerOpt(), request.getSp()).get(), usage)) {
                    this.runInvalidCondition(request);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public IfUsage getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new NumberConditionFeature(this.getParent(), FeatureSettingsSCore.ifUsage));
    }

    @Override
    public IfUsage getNewInstance(FeatureParentInterface parent) {
        return new IfUsage(parent);
    }
}

