/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.custom.condition;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.custom.CustomConditionFeature;
import com.ssomar.score.features.custom.conditions.custom.CustomConditionRequest;
import com.ssomar.score.features.types.BooleanFeature;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class IfNotOwnerOfTheEI
extends CustomConditionFeature<BooleanFeature, IfNotOwnerOfTheEI> {
    public IfNotOwnerOfTheEI(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifNotOwnerOfTheEI);
    }

    @Override
    public boolean verifCondition(CustomConditionRequest request) {
        if (((BooleanFeature)this.getCondition()).getValue(request.getSp()).booleanValue()) {
            ItemStack itemStack = request.getItemStack();
            Player player = request.getLauncher();
            if (itemStack.hasItemMeta() && player != null) {
                ItemMeta iM = itemStack.getItemMeta();
                NamespacedKey key = new NamespacedKey((Plugin)SCore.plugin, "ownerUUID");
                String uuidStr = (String)iM.getPersistentDataContainer().get(key, PersistentDataType.STRING);
                boolean invalid = false;
                UUID uuid = null;
                try {
                    uuid = UUID.fromString(uuidStr);
                }
                catch (Exception e) {
                    invalid = true;
                }
                if (!invalid && uuid.equals(player.getUniqueId())) {
                    this.runInvalidCondition(request);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public IfNotOwnerOfTheEI getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new BooleanFeature(this, false, FeatureSettingsSCore.ifNotOwnerOfTheEI));
    }

    @Override
    public boolean hasCondition() {
        return ((BooleanFeature)this.getCondition()).isConfigured();
    }

    @Override
    public IfNotOwnerOfTheEI getNewInstance(FeatureParentInterface parent) {
        return new IfNotOwnerOfTheEI(parent);
    }
}

