/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.types.list.ListEffectAndLevelFeature;
import java.util.HashMap;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class IfPlayerNotHasEffect
extends PlayerConditionFeature<ListEffectAndLevelFeature, IfPlayerNotHasEffect> {
    public IfPlayerNotHasEffect(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifPlayerNotHasEffect);
    }

    @Override
    public boolean verifCondition(PlayerConditionRequest request) {
        if (this.hasCondition()) {
            Player player = request.getPlayer();
            Object condition = ((ListEffectAndLevelFeature)this.getCondition()).getValue();
            for (PotionEffectType pET : condition.keySet()) {
                if (!player.hasPotionEffect(pET) || player.getPotionEffect(pET).getAmplifier() < (Integer)condition.get(pET)) continue;
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfPlayerNotHasEffect getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new ListEffectAndLevelFeature(this, new HashMap<PotionEffectType, Integer>(), FeatureSettingsSCore.ifPlayerNotHasEffect, true));
    }

    @Override
    public boolean hasCondition() {
        return ((ListEffectAndLevelFeature)this.getCondition()).getValue().size() > 0;
    }

    @Override
    public IfPlayerNotHasEffect getNewInstance(FeatureParentInterface parent) {
        return new IfPlayerNotHasEffect(parent);
    }
}

