/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.firework.explosion;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.FireworkEffectTypeFeature;
import com.ssomar.score.features.types.list.ListBukkitColorFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class FireworkExplosionFeatures
extends FeatureWithHisOwnEditor<FireworkExplosionFeatures, FireworkExplosionFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItem {
    private FireworkEffectTypeFeature type;
    private ListBukkitColorFeature colors;
    private ListBukkitColorFeature fadeColors;
    private BooleanFeature hasTrail;
    private BooleanFeature hasTwinkle;
    private String id;

    public FireworkExplosionFeatures(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.fireworkExplosion);
        this.id = id;
        this.reset();
    }

    public FireworkExplosionFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.fireworkExplosion);
        this.reset();
    }

    @Override
    public void reset() {
        this.type = new FireworkEffectTypeFeature(this, Optional.empty(), FeatureSettingsSCore.type);
        this.colors = new ListBukkitColorFeature((FeatureParentInterface)this, new ArrayList<Color>(), FeatureSettingsSCore.colors, Optional.empty());
        this.fadeColors = new ListBukkitColorFeature((FeatureParentInterface)this, new ArrayList<Color>(), FeatureSettingsSCore.fadeColors, Optional.empty());
        this.hasTrail = new BooleanFeature(this, true, FeatureSettingsSCore.hasTrail);
        this.hasTwinkle = new BooleanFeature(this, true, FeatureSettingsSCore.hasTwinkle);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String nameOrId = this.getName();
        if (this.id != null && !this.id.isEmpty()) {
            nameOrId = this.id;
        }
        if (config.isConfigurationSection(nameOrId)) {
            ConfigurationSection section = config.getConfigurationSection(nameOrId);
            errors.addAll(this.colors.load(plugin, section, isPremiumLoading));
            errors.addAll(this.fadeColors.load(plugin, section, isPremiumLoading));
            errors.addAll(this.type.load(plugin, section, isPremiumLoading));
            errors.addAll(this.hasTrail.load(plugin, section, isPremiumLoading));
            errors.addAll(this.hasTwinkle.load(plugin, section, isPremiumLoading));
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        String nameOrId = this.getName();
        if (this.id != null && !this.id.isEmpty()) {
            nameOrId = this.id;
        }
        config.set(nameOrId, null);
        ConfigurationSection section = config.createSection(nameOrId);
        this.colors.save(section);
        this.fadeColors.save(section);
        this.type.save(section);
        this.hasTrail.save(section);
        this.hasTwinkle.save(section);
    }

    @Override
    public FireworkExplosionFeatures getValue() {
        return this;
    }

    @Override
    public FireworkExplosionFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 6];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 6] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 5] = "&7Type: &e" + ((Optional)this.type.getValue()).orElse(FireworkEffect.Type.BALL);
        finalDescription[finalDescription.length - 4] = "&7Colors: &e" + Arrays.toString(this.colors.getValues().toArray());
        finalDescription[finalDescription.length - 3] = "&7Fade Colors: &e" + Arrays.toString(this.fadeColors.getValues().toArray());
        finalDescription[finalDescription.length - 2] = "&7Trail: " + (this.hasTrail.getValue() != false ? "&aTrue" : "&cFalse");
        finalDescription[finalDescription.length - 1] = "&7Twinkle: " + (this.hasTwinkle.getValue() != false ? "&aTrue" : "&cFalse");
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public FireworkExplosionFeatures clone(FeatureParentInterface newParent) {
        FireworkExplosionFeatures clone = new FireworkExplosionFeatures(newParent);
        clone.setColors(this.colors.clone(clone));
        clone.setFadeColors(this.fadeColors.clone(clone));
        clone.setType(this.type.clone(clone));
        clone.setHasTrail(this.hasTrail.clone(clone));
        clone.setHasTwinkle(this.hasTwinkle.clone(clone));
        clone.setId(this.id);
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.type);
        features.add(this.colors);
        features.add(this.fadeColors);
        features.add(this.hasTrail);
        features.add(this.hasTwinkle);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof FireworkExplosionFeatures) || !feature.getName().equals(this.getName()) || this.id != null && !this.id.isEmpty() && !Objects.equals(((FireworkExplosionFeatures)feature).getId(), this.getId())) continue;
            FireworkExplosionFeatures hiders = (FireworkExplosionFeatures)feature;
            hiders.setColors(this.colors);
            hiders.setFadeColors(this.fadeColors);
            hiders.setType(this.type);
            hiders.setHasTrail(this.hasTrail);
            hiders.setHasTwinkle(this.hasTwinkle);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openBackEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean isAvailable() {
        return !SCore.is1v12Less();
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return args.getMeta() instanceof FireworkEffectMeta;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        ItemMeta itemMeta = args.getMeta();
        if (itemMeta instanceof FireworkEffectMeta && !this.getColors().getValue().isEmpty()) {
            FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)itemMeta;
            FireworkEffect.Builder builder = FireworkEffect.builder();
            if (this.getHasTrail().getValue().booleanValue()) {
                builder.withTrail();
            }
            if (this.getHasTwinkle().getValue().booleanValue()) {
                builder.withFlicker();
            }
            if (!this.getFadeColors().getValue().isEmpty()) {
                builder.withFade((Iterable)this.getFadeColors().getValue());
            }
            if (((Optional)this.getType().getValue()).isPresent()) {
                builder.with((FireworkEffect.Type)((Optional)this.getType().getValue()).get());
            }
            builder.withColor((Iterable)this.getColors().getValue());
            fireworkEffectMeta.setEffect(builder.build());
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        ItemMeta itemMeta = args.getMeta();
        if (itemMeta instanceof FireworkEffectMeta) {
            FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)itemMeta;
            if (!fireworkEffectMeta.hasEffect()) {
                return;
            }
            FireworkEffect effect = fireworkEffectMeta.getEffect();
            this.getType().setValue(Optional.of(effect.getType()));
            this.getColors().setValues(effect.getColors());
            this.getFadeColors().setValues(effect.getFadeColors());
            this.getHasTrail().setValue(effect.hasTrail());
            this.getHasTwinkle().setValue(effect.hasFlicker());
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.FIREWORK_EXPLOSION;
    }

    @Generated
    public FireworkEffectTypeFeature getType() {
        return this.type;
    }

    @Generated
    public ListBukkitColorFeature getColors() {
        return this.colors;
    }

    @Generated
    public ListBukkitColorFeature getFadeColors() {
        return this.fadeColors;
    }

    @Generated
    public BooleanFeature getHasTrail() {
        return this.hasTrail;
    }

    @Generated
    public BooleanFeature getHasTwinkle() {
        return this.hasTwinkle;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setType(FireworkEffectTypeFeature type) {
        this.type = type;
    }

    @Generated
    public void setColors(ListBukkitColorFeature colors) {
        this.colors = colors;
    }

    @Generated
    public void setFadeColors(ListBukkitColorFeature fadeColors) {
        this.fadeColors = fadeColors;
    }

    @Generated
    public void setHasTrail(BooleanFeature hasTrail) {
        this.hasTrail = hasTrail;
    }

    @Generated
    public void setHasTwinkle(BooleanFeature hasTwinkle) {
        this.hasTwinkle = hasTwinkle;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

