/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireClicksOrOneMessageInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MaterialFeature
extends FeatureAbstract<Optional<Material>, MaterialFeature>
implements FeatureRequireClicksOrOneMessageInEditor {
    private Optional<Material> value;
    private Optional<Material> defaultValue;
    private boolean onlyItemMaterial;

    public MaterialFeature(FeatureParentInterface parent, Optional<Material> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
        this.onlyItemMaterial = false;
    }

    public MaterialFeature(FeatureParentInterface parent, Optional<Material> defaultValue, FeatureSettingsInterface featureSettings, boolean onlyItemMaterial) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
        this.onlyItemMaterial = onlyItemMaterial;
    }

    public static MaterialFeature buildNull() {
        return new MaterialFeature(null, Optional.of(Material.STONE), FeatureSettingsSCore.material);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        try {
            Material material = Material.valueOf((String)colorStr);
            if (!SCore.is1v11Less() && this.onlyItemMaterial && !material.isItem()) {
                material = Material.STONE;
            }
            this.value = Optional.ofNullable(material);
            FeatureReturnCheckPremium<Material> checkPremium = this.checkPremium("Material", material, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            if (!colorStr.equals("NULL")) {
                errors.add("&cERROR, Couldn't load the Material value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> Materials available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Material.html");
            }
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (((Optional)this.getValue()).isPresent()) {
            if (this.defaultValue.isPresent() && this.isSavingOnlyIfDiffDefault() && ((Material)((Optional)this.getValue()).get()).equals((Object)this.defaultValue.get())) {
                config.set(this.getName(), null);
                return;
            }
            config.set(this.getName(), (Object)((Material)((Optional)this.getValue()).get()).name());
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        } else if (SCore.is1v19Plus()) {
            config.setComments(this.getName(), null);
        }
    }

    @Override
    public Optional<Material> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public MaterialFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = "&8>> &6SHIFT : &eBOOST SCROLL";
        finalDescription[finalDescription.length - 2] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        finalDescription[finalDescription.length - 1] = "&8>> &6Type manually: &eMIDDLE &a(Creative only)";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        Material finalValue = ((Optional)value).orElse(Material.STONE);
        this.updateMaterial(finalValue, gui);
    }

    @Override
    public MaterialFeature clone(FeatureParentInterface newParent) {
        MaterialFeature clone = new MaterialFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.isOnlyItemMaterial());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        Material material = this.getMaterial((GUI)manager.getCache().get(editor));
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        material = this.nextMaterial(material);
        this.updateMaterial(material, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        Material material = this.getMaterial((GUI)manager.getCache().get(editor));
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        material = this.prevMaterial(material);
        this.updateMaterial(material, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateMaterial(this.nextMaterial(this.getMaterial((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateMaterial(this.prevMaterial(this.getMaterial((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public Material nextMaterial(Material material) {
        boolean next = false;
        for (Material check : this.getSortMaterials()) {
            if (check.equals((Object)material)) {
                next = true;
                continue;
            }
            if (!next || !SCore.is1v11Less() && this.onlyItemMaterial && !check.isItem()) continue;
            return check;
        }
        return this.getSortMaterials().get(0);
    }

    public Material prevMaterial(Material material) {
        int i = -1;
        int cpt = 0;
        for (Material check : this.getSortMaterials()) {
            if (check.equals((Object)material)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        Material finalMaterial = i == 0 ? this.getSortMaterials().get(this.getSortMaterials().size() - 1) : this.getSortMaterials().get(cpt - 1);
        if (!SCore.is1v11Less() && this.onlyItemMaterial && !finalMaterial.isItem()) {
            return this.prevMaterial(finalMaterial);
        }
        return finalMaterial;
    }

    public void updateMaterial(Material material, GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        this.value = Optional.of(material);
        item.setType(material);
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList();
            for (String str : this.getEditorDescription()) {
                lore.add(StringConverter.coloredString(str));
            }
        } else {
            lore = lore.subList(0, this.getEditorDescription().length + 4);
        }
        boolean find = false;
        for (Material check : this.getSortMaterials()) {
            if (material.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + material.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (Material check : this.getSortMaterials()) {
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public Material getMaterial(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return Material.valueOf((String)str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<Material> getSortMaterials() {
        TreeMap<String, Material> map = new TreeMap<String, Material>();
        for (Material l : Material.values()) {
            if (SCore.is1v12Less()) {
                try {
                    ItemStack item = new ItemStack(l);
                    if (item == null || item.getType() == Material.AIR) continue;
                    Inventory inv = Bukkit.createInventory(null, (int)9);
                    inv.setItem(0, new ItemStack(l));
                    if (inv.getItem(0) == null) continue;
                    map.put(l.name(), l);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!l.isItem() || l.isAir()) continue;
            map.put(l.name(), l);
        }
        return new ArrayList<Material>(map.values());
    }

    @Override
    public void askInEditor(final Player editor, NewGUIManager manager) {
        manager.requestWriting.put(editor, this.getEditorName());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                editor.closeInventory();
            }
        };
        SCore.schedulerHook.runTask(runnable, 0L);
        MaterialFeature.space(editor);
        TextComponent message = new TextComponent(StringConverter.coloredString("&a&l[Editor] &aEnter the material or &aedit &athe &aactual: "));
        TextComponent edit = new TextComponent(StringConverter.coloredString("&e&l[EDIT]"));
        edit.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, StringConverter.deconvertColor(((GUI)manager.getCache().get(editor)).getCurrently(this.getEditorName()))));
        edit.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&eClick here to edit the current material")).create()));
        TextComponent newName = new TextComponent(StringConverter.coloredString("&a&l[NEW]"));
        newName.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "Type the new string here.."));
        newName.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick here to set new material")).create()));
        TextComponent noValue = new TextComponent(StringConverter.coloredString("&c&l[NO VALUE / EXIT]"));
        noValue.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/score interact NO VALUE / EXIT"));
        noValue.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&cClick here to exit or don't set a value")).create()));
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)edit);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)newName);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)noValue);
        editor.spigot().sendMessage((BaseComponent)message);
        MaterialFeature.space(editor);
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        try {
            Material.valueOf((String)StringConverter.decoloredString(message).trim().toUpperCase());
        }
        catch (Exception e) {
            return Optional.of(StringConverter.coloredString("&4&l[ERROR] &cThe message you entered is not a material"));
        }
        return Optional.empty();
    }

    @Override
    public void finishEditInEditor(Player editor, NewGUIManager manager, String message) {
        this.value = Optional.of(Material.valueOf((String)StringConverter.decoloredString(message).trim().toUpperCase()));
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Override
    public void finishEditInEditorNoValue(Player editor, NewGUIManager manager) {
        this.value = Optional.empty();
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Generated
    public Optional<Material> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public boolean isOnlyItemMaterial() {
        return this.onlyItemMaterial;
    }

    @Generated
    public void setValue(Optional<Material> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<Material> defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setOnlyItemMaterial(boolean onlyItemMaterial) {
        this.onlyItemMaterial = onlyItemMaterial;
    }
}

