/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SCore;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.RequiredObject;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RequiredObjectFeature
extends FeatureAbstract<Optional<RequiredObject>, RequiredObjectFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<RequiredObject> value;
    private Optional<RequiredObject> defaultValue;

    public RequiredObjectFeature(FeatureParentInterface parent, Optional<RequiredObject> defaultValue, FeatureSettingsInterface settings) {
        super(parent, settings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        try {
            RequiredObject attributeSlot = RequiredObject.valueOf(colorStr.toUpperCase());
            this.value = Optional.ofNullable(attributeSlot);
            FeatureReturnCheckPremium<RequiredObject> checkPremium = this.checkPremium("RequiredObject", attributeSlot, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            errors.add("&cERROR, Couldn't load the RequiredObject value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> HEAD, CHEST, FEET, LEGS, HAND, OFF_HAND, ALL_SLOTS");
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        if (((Optional)value).isPresent()) {
            config.set(this.getName(), (Object)((RequiredObject)((Object)((Optional)value).get())).name());
        }
    }

    @Override
    public Optional<RequiredObject> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    public Optional<EquipmentSlot> getEquipmentSlotValue() {
        if (((Optional)this.getValue()).isPresent()) {
            try {
                return Optional.of(EquipmentSlot.valueOf((String)((RequiredObject)((Object)((Optional)this.getValue()).get())).name().toUpperCase()));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public RequiredObjectFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7currently: ";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        RequiredObject finalValue = ((Optional)value).orElse(RequiredObject.REQUIRE_VANILLA_ITEM);
        this.updateRequiredObject(finalValue, gui, false);
    }

    @Override
    public RequiredObjectFeature clone(FeatureParentInterface newParent) {
        RequiredObjectFeature clone = new RequiredObjectFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        RequiredObject slot = this.getRequiredObject((GUI)manager.getCache().get(editor));
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        slot = this.nextRequiredObject(slot);
        this.updateRequiredObject(slot, (GUI)manager.getCache().get(editor), true);
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        RequiredObject slot = this.getRequiredObject((GUI)manager.getCache().get(editor));
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        slot = this.prevRequiredObject(slot);
        this.updateRequiredObject(slot, (GUI)manager.getCache().get(editor), true);
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateRequiredObject(this.nextRequiredObject(this.getRequiredObject((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor), false);
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateRequiredObject(this.prevRequiredObject(this.getRequiredObject((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor), true);
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public RequiredObject nextRequiredObject(RequiredObject slot) {
        boolean next = false;
        for (RequiredObject check : this.getSortRequiredObjects()) {
            if (check.equals((Object)slot)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortRequiredObjects().get(0);
    }

    public RequiredObject prevRequiredObject(RequiredObject slot) {
        int i = -1;
        int cpt = 0;
        for (RequiredObject check : this.getSortRequiredObjects()) {
            if (check.equals((Object)slot)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortRequiredObjects().get(this.getSortRequiredObjects().size() - 1);
        }
        return this.getSortRequiredObjects().get(cpt - 1);
    }

    public void updateRequiredObject(RequiredObject rO, GUI gui, boolean previous) {
        if (rO.equals((Object)RequiredObject.REQUIRE_ITEM_FROM_EXECUTABLEITEMS) && !SCore.hasExecutableItems || rO.equals((Object)RequiredObject.REQUIRE_ITEM_FROM_ITEMADDERS) && !SCore.hasItemsAdder) {
            if (previous) {
                this.updateRequiredObject(this.prevRequiredObject(rO), gui, previous);
            } else {
                this.updateRequiredObject(this.nextRequiredObject(rO), gui, previous);
            }
            return;
        }
        this.value = Optional.of(rO);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortRequiredObjects().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (RequiredObject check : this.getSortRequiredObjects()) {
            if (rO.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + rO.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (RequiredObject check : this.getSortRequiredObjects()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        for (HumanEntity e : gui.getInv().getViewers()) {
            if (!(e instanceof Player)) continue;
            Player p = (Player)e;
            p.updateInventory();
        }
    }

    public RequiredObject getRequiredObject(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return RequiredObject.valueOf(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<RequiredObject> getSortRequiredObjects() {
        TreeMap<String, RequiredObject> map = new TreeMap<String, RequiredObject>();
        for (RequiredObject l : RequiredObject.values()) {
            map.put(l.name(), l);
        }
        return new ArrayList<RequiredObject>(map.values());
    }

    @Generated
    public Optional<RequiredObject> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<RequiredObject> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<RequiredObject> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

