/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.emums;

import com.ssomar.score.SCore;
import com.ssomar.score.utils.FixedMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import org.bukkit.Material;

public enum MaterialWithGroups {
    ALL_CHESTS(FixedMaterial.getMaterials(Arrays.asList("CHEST", "TRAPPED_CHEST", "ENDER_CHEST"))),
    ALL_FURNACES(FixedMaterial.getMaterials(Arrays.asList("FURNACE", "FURNACE_MINECART", "BLAST_FURNACE"))),
    ALL_PLANKS(FixedMaterial.getMaterials(Arrays.asList("MANGROVE_PLANKS", "WARPED_PLANKS", "OAK_PLANKS", "SPRUCE_PLANKS", "BIRCH_PLANKS", "JUNGLE_PLANKS", "ACACIA_PLANKS", "DARK_OAK_PLANKS", "CRIMSON_PLANKS", "CHERRY_PLANKS", "PALE_OAK_PLANKS"))),
    ALL_LOGS(FixedMaterial.getMaterials(Arrays.asList("WARPED_STEM", "CRIMSON_STEM", "MANGROVE_LOG", "WARPED_LOG", "OAK_LOG", "SPRUCE_LOG", "BIRCH_LOG", "JUNGLE_LOG", "ACACIA_LOG", "DARK_OAK_LOG", "CRIMSON_LOG", "CHERRY_LOG", "PALE_OAK_LOG"))),
    ALL_WOODS(FixedMaterial.getMaterials(Arrays.asList("MANGROVE_WOOD", "WARPED_WOOD", "OAK_WOOD", "SPRUCE_WOOD", "BIRCH_WOOD", "JUNGLE_WOOD", "ACACIA_WOOD", "DARK_OAK_WOOD", "CRIMSON_WOOD", "CHERY_WOOD", "PALE_OAK_WOOD"))),
    ALL_STRIPPED_LOGS(FixedMaterial.getMaterials(Arrays.asList("STRIPPED_OAK_LOG", "STRIPPED_SPRUCE_LOG", "STRIPPED_BIRCH_LOG", "STRIPPED_JUNGLE_LOG", "STRIPPED_ACACIA_LOG", "STRIPPED_DARK_OAK_LOG", "STRIPPED_CRIMSON_LOG", "STRIPPED_WARPED_LOG", "STRIPPED_PALE_OAK_LOG"))),
    ALL_STRIPPED_WOODS(FixedMaterial.getMaterials(Arrays.asList("STRIPPED_OAK_WOOD", "STRIPPED_SPRUCE_WOOD", "STRIPPED_BIRCH_WOOD", "STRIPPED_JUNGLE_WOOD", "STRIPPED_ACACIA_WOOD", "STRIPPED_DARK_OAK_WOOD", "STRIPPED_CRIMSON_WOOD", "STRIPPED_WARPED_WOOD", "STRIPPED_PALE_OAK_WOOD"))),
    ALL_ORES(FixedMaterial.getMaterials(Arrays.asList("COAL_ORE", "DEEPSLATE_COAL_ORE", "IRON_ORE", "DEEPSLATE_IRON_ORE", "COPPER_ORE", "DEEPSLATE_COPPER_ORE", "GOLD_ORE", "DEEPSLATE_GOLD_ORE", "REDSTONE_ORE", "DEEPSLATE_REDSTONE_ORE", "EMERALD_ORE", "DEEPSLATE_EMERALD_ORE", "LAPIS_ORE", "DEEPSLATE_LAPIS_ORE", "DIAMOND_ORE", "DEEPSLATE_DIAMOND_ORE", "NETHER_GOLD_ORE", "NETHER_QUARTZ_ORE"))),
    ALL_WOOLS(FixedMaterial.getMaterials(Arrays.asList("WHITE_WOOL", "ORANGE_WOOL", "MAGENTA_WOOL", "LIGHT_BLUE_WOOL", "YELLOW_WOOL", "LIME_WOOL", "PINK_WOOL", "GRAY_WOOL", "LIGHT_GRAY_WOOL", "CYAN_WOOL", "PURPLE_WOOL", "BLUE_WOOL", "BROWN_WOOL", "GREEN_WOOL", "RED_WOOL", "BLACK_WOOL"))),
    ALL_SLABS(FixedMaterial.getMaterialsContains("SLAB")),
    ALL_STAIRS(FixedMaterial.getMaterialsContains("STAIRS")),
    ALL_FENCES(FixedMaterial.getMaterialsContains("FENCE")),
    ALL_SAPLINGS(FixedMaterial.getMaterialsContains("SAPLING")),
    ALL_CROPS(FixedMaterial.getMaterials(Arrays.asList("CROPS", "NETHER_WARTS", "POTATO", "CARROT", "BEETROOT_BLOCK", "WHEAT", "CARROTS", "BEETROOTS", "POTATOES", "NETHER_WART"))),
    ALL_DOORS(FixedMaterial.getMaterialsContains("DOOR", "TRAPDOOR")),
    ALL_TRAPDOORS(FixedMaterial.getMaterialsContains("TRAPDOOR")),
    ALL_BEDS(FixedMaterial.getMaterialsContains("BED")),
    ALL_TERRACOTTA(FixedMaterial.getMaterialsContains("TERRACOTTA")),
    ALL_NORMAL_TERRACOTTA(FixedMaterial.getMaterialsContains("TERRACOTTA", "GLAZED")),
    ALL_GLAZED_TERRACOTTA(FixedMaterial.getMaterialsContains("GLAZED_TERRACOTTA")),
    ALL_CONCRETE(FixedMaterial.getMaterialsContains("CONCRETE")),
    ALL_CONCRETE_POWDERS(FixedMaterial.getMaterialsContains("CONCRETE_POWDER")),
    ALL_GLASS(FixedMaterial.getMaterialsContains("GLASS")),
    ALL_STAINED_GLASS(FixedMaterial.getMaterialsContains("STAINED_GLASS")),
    ALL_SHULKER_BOXES(FixedMaterial.getMaterialsContains("SHULKER_BOX")),
    ALL_LEAVES(FixedMaterial.getMaterialsContains("LEAVES")),
    ALL_CARPETS(FixedMaterial.getMaterialsContains("CARPET"));

    private List<Material> materials;

    private MaterialWithGroups(List<Material> materials) {
        this.materials = materials;
    }

    public static boolean verif(Material material, String name) {
        name = name.toUpperCase();
        MaterialWithGroups materialWithGroups = null;
        for (MaterialWithGroups materialGroup : MaterialWithGroups.values()) {
            if (!materialGroup.name().equals(name)) continue;
            materialWithGroups = materialGroup;
        }
        if (materialWithGroups == null) {
            try {
                return material.equals((Object)Material.valueOf((String)name));
            }
            catch (Exception e) {
                return false;
            }
        }
        return materialWithGroups.materials.contains(material);
    }

    public static Optional<String> getMaterialWithGroups(String name) {
        name = name.toUpperCase();
        for (MaterialWithGroups materialWithGroups : MaterialWithGroups.values()) {
            if (!materialWithGroups.name().equals(name)) continue;
            return Optional.of(materialWithGroups.name());
        }
        for (MaterialWithGroups materialWithGroups : Material.values()) {
            if (!materialWithGroups.name().equals(name)) continue;
            return Optional.of(materialWithGroups.name());
        }
        return Optional.empty();
    }

    public static List<String> getMaterialWithGroupsList(boolean acceptAir, boolean acceptItem, boolean acceptBlock) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (MaterialWithGroups materialWithGroups : MaterialWithGroups.values()) {
            map.put(materialWithGroups.name(), materialWithGroups.name());
        }
        for (MaterialWithGroups materialWithGroups : Material.values()) {
            if (!SCore.is1v12Less() && materialWithGroups.isAir() || SCore.is1v12Less() && materialWithGroups.equals(Material.AIR)) {
                if (!acceptAir) continue;
                map.put(materialWithGroups.name(), materialWithGroups.name());
            }
            if (acceptItem && materialWithGroups.isItem()) {
                map.put(materialWithGroups.name(), materialWithGroups.name());
                continue;
            }
            if (!acceptBlock || !materialWithGroups.isBlock()) continue;
            map.put(materialWithGroups.name(), materialWithGroups.name());
        }
        return new ArrayList<String>(map.values());
    }

    public static Material getMaterial(String name) {
        name = name.toUpperCase();
        Enum materialWithGroups = null;
        for (MaterialWithGroups materialWithGroups2 : MaterialWithGroups.values()) {
            if (!materialWithGroups2.name().equals(name)) continue;
            materialWithGroups = materialWithGroups2;
        }
        if (materialWithGroups == null) {
            for (MaterialWithGroups materialWithGroups3 : Material.values()) {
                if (!materialWithGroups3.name().equals(name)) continue;
                if (SCore.is1v12Less() && materialWithGroups3.equals(Material.AIR)) {
                    return Material.BARRIER;
                }
                if (!SCore.is1v12Less() && materialWithGroups3.isAir()) {
                    return Material.BARRIER;
                }
                if (!materialWithGroups3.isItem()) {
                    return Material.BARRIER;
                }
                return materialWithGroups3;
            }
        } else {
            switch (materialWithGroups.ordinal()) {
                case 0: {
                    return FixedMaterial.getMaterial(Collections.singletonList("CHEST"));
                }
                case 1: {
                    return FixedMaterial.getMaterial(Collections.singletonList("FURNACE"));
                }
                case 2: {
                    return FixedMaterial.getMaterial(Collections.singletonList("OAK_PLANKS"));
                }
                case 3: {
                    return FixedMaterial.getMaterial(Collections.singletonList("OAK_LOG"));
                }
                case 4: {
                    return FixedMaterial.getMaterial(Collections.singletonList("OAK_WOOD"));
                }
                case 7: {
                    return FixedMaterial.getMaterial(Collections.singletonList("COAL_ORE"));
                }
                case 8: {
                    return FixedMaterial.getMaterial(Collections.singletonList("LIME_WOOL"));
                }
                case 9: {
                    return FixedMaterial.getMaterial(Collections.singletonList("STONE_SLAB"));
                }
                case 10: {
                    return FixedMaterial.getMaterial(Collections.singletonList("STONE_STAIRS"));
                }
                case 11: {
                    return FixedMaterial.getMaterial(Collections.singletonList("OAK_FENCE"));
                }
                case 12: {
                    return FixedMaterial.getMaterial(Collections.singletonList("OAK_SAPLING"));
                }
                case 13: {
                    return FixedMaterial.getMaterial(Arrays.asList("WHEAT", "CROPS"));
                }
                case 14: {
                    return FixedMaterial.getMaterial(Collections.singletonList("OAK_DOOR"));
                }
                case 15: {
                    return FixedMaterial.getMaterial(Collections.singletonList("OAK_TRAPDOOR"));
                }
                case 16: {
                    return FixedMaterial.getMaterial(Collections.singletonList("OAK_BED"));
                }
                case 17: {
                    return FixedMaterial.getMaterial(Collections.singletonList("TERRACOTTA"));
                }
                case 18: {
                    return FixedMaterial.getMaterial(Collections.singletonList("LIME_TERRACOTTA"));
                }
                case 19: {
                    return FixedMaterial.getMaterial(Collections.singletonList("LIME_GLAZED_TERRACOTTA"));
                }
                case 20: {
                    return FixedMaterial.getMaterial(Collections.singletonList("LIME_CONCRETE"));
                }
                case 22: {
                    return FixedMaterial.getMaterial(Collections.singletonList("GLASS"));
                }
                case 23: {
                    return FixedMaterial.getMaterial(Collections.singletonList("LIME_STAINED_GLASS"));
                }
                case 24: {
                    return FixedMaterial.getMaterial(Collections.singletonList("LIME_SHULKER_BOX"));
                }
                case 25: {
                    return FixedMaterial.getMaterial(Collections.singletonList("OAK_LEAVES"));
                }
                case 26: {
                    return FixedMaterial.getMaterial(Arrays.asList("WHITE_CARPET", "CARPET"));
                }
            }
        }
        return Material.STONE;
    }
}

