/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.sevents.events.player.click.right;

import com.ssomar.sevents.events.player.click.CancelOffHandInteractionManager;
import com.ssomar.sevents.events.player.click.TooManyInteractionManager;
import com.ssomar.sevents.events.player.click.right.PlayerRightClickEvent;
import com.ssomar.sevents.version.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class PlayerRightClickListener
implements Listener {
    private final List<Material> invoke2LeftClick = new ArrayList<Material>();
    private final List<Material> invoke3LeftClick = new ArrayList<Material>();

    public PlayerRightClickListener() {
        this.invoke2LeftClick.add(Material.WRITTEN_BOOK);
        if (Version.is1v12Less()) {
            this.invoke2LeftClick.add(Material.valueOf((String)"EXP_BOTTLE"));
            this.invoke2LeftClick.add(Material.valueOf((String)"SNOW_BALL"));
            this.invoke2LeftClick.add(Material.valueOf((String)"EYE_OF_ENDER"));
        } else {
            this.invoke2LeftClick.add(Material.EXPERIENCE_BOTTLE);
            this.invoke2LeftClick.add(Material.SNOWBALL);
            this.invoke2LeftClick.add(Material.FISHING_ROD);
            this.invoke3LeftClick.add(Material.ENDER_EYE);
        }
        this.invoke2LeftClick.add(Material.ENDER_PEARL);
        if (!Version.is1v11Less()) {
            this.invoke2LeftClick.add(Material.SPLASH_POTION);
            this.invoke2LeftClick.add(Material.KNOWLEDGE_BOOK);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerInteractEvent(PlayerInteractEvent e) {
        EquipmentSlot equipSlot;
        Player p = e.getPlayer();
        UUID pUUID = p.getUniqueId();
        Action action = e.getAction();
        if (action.equals((Object)Action.PHYSICAL)) {
            return;
        }
        if (!Version.is1v11Less() && ((equipSlot = e.getHand()) == null || equipSlot.equals((Object)EquipmentSlot.OFF_HAND))) {
            if (CancelOffHandInteractionManager.getInstance().containsKey(pUUID)) {
                CancelOffHandInteractionManager.getInstance().remove(pUUID);
                e.setCancelled(true);
            }
            if (!p.getInventory().getItemInMainHand().getType().equals((Object)Material.AIR) || !action.toString().contains("AIR")) {
                if (p.getInventory().getItemInOffHand().getType().toString().contains("SPAWN_EGG")) {
                    e.setCancelled(true);
                }
                return;
            }
        }
        if (!action.equals((Object)Action.LEFT_CLICK_AIR) && !action.equals((Object)Action.LEFT_CLICK_BLOCK)) {
            PlayerRightClickEvent playerRightClickEvent = new PlayerRightClickEvent(e.getPlayer(), e.getClickedBlock(), e.getBlockFace(), e.useItemInHand().equals((Object)Event.Result.DENY), (Event)e);
            Bukkit.getServer().getPluginManager().callEvent((Event)playerRightClickEvent);
            if (playerRightClickEvent.isCancelled()) {
                e.setCancelled(true);
                e.setUseItemInHand(Event.Result.DENY);
                e.setUseInteractedBlock(Event.Result.DENY);
                CancelOffHandInteractionManager.getInstance().put(pUUID, 1);
            }
        }
        if (action.equals((Object)Action.RIGHT_CLICK_AIR)) {
            if (this.invoke2LeftClick.contains(e.getItem().getType())) {
                if (e.isCancelled()) {
                    TooManyInteractionManager.getInstance().put(p.getUniqueId(), 1);
                } else {
                    TooManyInteractionManager.getInstance().put(p.getUniqueId(), 2);
                }
            } else if (this.invoke3LeftClick.contains(e.getItem().getType())) {
                if (e.isCancelled()) {
                    TooManyInteractionManager.getInstance().put(p.getUniqueId(), 2);
                } else {
                    TooManyInteractionManager.getInstance().put(p.getUniqueId(), 3);
                }
            }
        }
    }
}

