/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.particles.commands;

import com.ssomar.particles.commands.XParticle;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bukkit.Particle;

public class Parameter<T> {
    private String name;
    private T value;
    private T defaultValue;
    private String description;

    public Parameter(String name, T defaultValue, String description) {
        this.name = name;
        this.value = defaultValue;
        this.defaultValue = defaultValue;
        this.description = description;
    }

    public void load(String[] parameters) {
        this.load(Arrays.asList(parameters));
    }

    public void load(List<String> parameters) {
        for (String s : parameters) {
            String[] split = s.split(":");
            if (!split[0].equalsIgnoreCase(this.name) || split.length != 2) continue;
            String valueStr = split[1];
            this.value = this.value instanceof Integer ? Integer.valueOf(valueStr) : (this.value instanceof Double ? Double.valueOf(valueStr) : (this.value instanceof Float ? Float.valueOf(valueStr) : (this.value instanceof Boolean ? Boolean.valueOf(Boolean.parseBoolean(valueStr)) : (this.value instanceof String ? valueStr : (this.value instanceof Particle ? XParticle.getParticle(valueStr) : (this.value instanceof Long ? Long.valueOf(valueStr) : (this.value instanceof Short ? Short.valueOf(valueStr) : (this.value instanceof Byte ? (Comparable<Byte>)Byte.valueOf(valueStr) : (Comparable<Byte>)(this.value instanceof Character ? Character.valueOf(valueStr.charAt(0)) : this.defaultValue)))))))));
            return;
        }
        this.value = this.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    @Generated
    public T getValue() {
        return this.value;
    }
}

