/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.events.BlockBreakEventExtension;
import com.ssomar.score.utils.ToolsListMaterial;
import com.ssomar.score.utils.safebreak.SafeBreak;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FarmInCube
extends BlockCommand {
    private static final boolean DEBUG = true;

    public static void destroyTheBlock(final Block toDestroy, final boolean onlyMaxAge, final boolean drop, final boolean replant, final @Nullable Player p, final boolean event, final int slot) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Ageable ageable;
                BlockData data = toDestroy.getState().getBlockData().clone();
                Material bMat = toDestroy.getType();
                if (onlyMaxAge && data instanceof Ageable && (ageable = (Ageable)data).getAge() != ageable.getMaximumAge()) {
                    return;
                }
                if (ToolsListMaterial.getInstance().getPlantWithGrowth().contains(bMat)) {
                    UUID uuid = null;
                    if (p != null) {
                        uuid = p.getUniqueId();
                    }
                    if (!SafeBreak.breakBlockWithEvent(toDestroy, uuid, slot, drop, event, true, BlockBreakEventExtension.BreakCause.MINE_IN_CUBE)) {
                        return;
                    }
                    if (replant) {
                        FarmInCube.replant(toDestroy, data, bMat, p);
                    }
                }
            }
        };
        SCore.schedulerHook.runTask(runnable, 1L);
    }

    public static void replant(Block block, BlockData oldData, Material material, @Nullable Player player) {
        boolean needReplant = false;
        if (oldData instanceof Ageable) {
            Ageable ageable = (Ageable)oldData;
            Material required = ToolsListMaterial.getInstance().getRealMaterialOfBlock(material);
            if (player != null) {
                PlayerInventory inv = player.getInventory();
                if (inv.contains(required) && inv.removeItem(new ItemStack[]{new ItemStack(required)}).isEmpty()) {
                    needReplant = true;
                } else {
                    block.setType(Material.AIR);
                }
            } else {
                needReplant = true;
            }
            if (needReplant) {
                ageable.setAge(0);
                block.setType(material);
                block.setBlockData(oldData);
            }
        } else {
            block.setType(Material.AIR);
        }
    }

    @Override
    public void run(final Player p, final @NotNull Block block, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        final ActionInfo aInfo = sCommandToExec.getActionInfo();
        final Material oldMaterial = aInfo.getOldBlockMaterial();
        if (aInfo.isEventFromCustomBreakCommand()) {
            return;
        }
        List<Material> validMaterial = ToolsListMaterial.getInstance().getPlantWithGrowth();
        try {
            int radius = Integer.parseInt(args.get(0));
            boolean drop = true;
            if (args.size() >= 2) {
                drop = Boolean.parseBoolean(args.get(1));
            }
            boolean onlyMaxAge = true;
            if (args.size() >= 3) {
                onlyMaxAge = Boolean.parseBoolean(args.get(2));
            }
            boolean replant = false;
            if (args.size() >= 4) {
                replant = Boolean.parseBoolean(args.get(3));
            }
            boolean event = false;
            if (args.size() >= 5) {
                event = Boolean.parseBoolean(args.get(4));
            }
            if (radius >= 10) {
                radius = 9;
            }
            for (int y = -radius; y < radius + 1; ++y) {
                for (int x = -radius; x < radius + 1; ++x) {
                    for (int z = -radius; z < radius + 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        Block toDestroy = block.getWorld().getBlockAt(block.getX() + x, block.getY() + y, block.getZ() + z);
                        FarmInCube.destroyTheBlock(toDestroy, onlyMaxAge, drop, replant, p, event, aInfo.getSlot());
                    }
                }
            }
            SsomarDev.testMsg("OldMaterial : " + oldMaterial.toString(), true);
            if (validMaterial.contains(oldMaterial) && replant) {
                final boolean onlyMaxAgeFinal = onlyMaxAge;
                final boolean dropFinal = drop;
                final boolean eventFinal = event;
                UUID uuid = null;
                if (p != null) {
                    uuid = p.getUniqueId();
                }
                final UUID uuidFinal = uuid;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Ageable ageable;
                        BlockData data = block.getState().getBlockData().clone();
                        if (onlyMaxAgeFinal && data instanceof Ageable && (ageable = (Ageable)data).getAge() != ageable.getMaximumAge()) {
                            return;
                        }
                        if (!block.getType().equals((Object)Material.AIR) && !SafeBreak.breakBlockWithEvent(block, uuidFinal, aInfo.getSlot(), dropFinal, eventFinal, true, BlockBreakEventExtension.BreakCause.MINE_IN_CUBE)) {
                            return;
                        }
                        block.setType(oldMaterial);
                        data = block.getState().getBlockData().clone();
                        if (aInfo.getBlockFace() != null && data instanceof Directional) {
                            Directional directional = (Directional)data;
                            directional.setFacing(aInfo.getBlockFace());
                            block.setBlockData((BlockData)directional);
                        }
                        FarmInCube.replant(block, data, oldMaterial, p);
                    }
                };
                SCore.schedulerHook.runLocationTask(runnable, block.getLocation(), 1L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("FARMINCUBE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "FARMINCUBE {radius} [ActiveDrop true or false] [onlyMaxAge true or false] [replant true or false] [event true or false]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

