/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.usedapi.MultiverseAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class WorldTeleport
extends MixedCommand {
    @Override
    public void run(Player p, Entity receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        if (args.size() == 1) {
            Location locP = receiver.getLocation();
            World world = SCore.hasMultiverse ? MultiverseAPI.getWorld(args.get(0)) : Bukkit.getWorld((String)args.get(0));
            int i = 0;
            boolean teleport = false;
            while (i < 999 && !teleport) {
                int y;
                Location newLoc = new Location(world, locP.getX() + (double)i, locP.getY(), locP.getZ());
                if (world.getEnvironment().equals((Object)World.Environment.NETHER)) {
                    y = receiver.getWorld().getHighestBlockYAt((int)newLoc.getX(), (int)newLoc.getZ());
                    newLoc.setY((double)y);
                    boolean block1 = false;
                    boolean block2 = false;
                    while (newLoc.getY() > 120.0) {
                        newLoc.subtract(0.0, 1.0, 0.0);
                    }
                    while (newLoc.getY() > 0.0) {
                        if (block1 && newLoc.getBlock().isEmpty()) {
                            block2 = true;
                        } else if (newLoc.getBlock().isEmpty()) {
                            block1 = true;
                        } else {
                            if (block1 && block2) {
                                if (newLoc.getBlock().getType().equals((Object)Material.LAVA)) {
                                    block1 = false;
                                    block2 = false;
                                } else {
                                    newLoc.add(0.0, 1.0, 0.0);
                                    receiver.teleport(newLoc);
                                    teleport = true;
                                }
                                break;
                            }
                            block1 = false;
                            block2 = false;
                        }
                        newLoc.subtract(0.0, 1.0, 0.0);
                    }
                } else {
                    y = receiver.getWorld().getHighestBlockYAt((int)newLoc.getX(), (int)newLoc.getZ());
                    newLoc.setY((double)y);
                    while (newLoc.getBlock().isEmpty() && newLoc.getY() > 0.0) {
                        newLoc.subtract(0.0, 1.0, 0.0);
                    }
                    if (newLoc.getBlock().getType().equals((Object)Material.LAVA) || newLoc.getBlock().isEmpty() && newLoc.getY() > 0.0) continue;
                    if (!newLoc.getBlock().isEmpty()) {
                        newLoc.add(0.0, 1.0, 0.0);
                        receiver.teleport(newLoc);
                        teleport = true;
                    }
                }
                ++i;
            }
            if (!teleport) {
                receiver.sendMessage("ERROR NO POS FOUND");
            }
        }
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        if (args.size() < 1) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + this.getTemplate());
        }
        ArgumentChecker ac = WorldTeleport.checkWorld(args.get(0), isFinalVerification, this.getTemplate());
        if (!ac.isValid()) {
            return Optional.of(ac.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("WORLD_TELEPORT");
        names.add("WORLDTELEPORT");
        return names;
    }

    @Override
    public String getTemplate() {
        return "WORLD_TELEPORT {world}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

