/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.RunConsoleCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.utils.safeplace.SafePlace;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;

public class SetBlock
extends PlayerCommand {
    public SetBlock() {
        CommandSetting blockFace = new CommandSetting("blockface", 0, BlockFace.class, null);
        CommandSetting material = new CommandSetting("material", 1, String.class, (Object)"STONE");
        CommandSetting bypassProtection = new CommandSetting("bypassProtection", -1, Boolean.class, (Object)true);
        List<CommandSetting> settings = this.getSettings();
        settings.add(material);
        settings.add(blockFace);
        settings.add(bypassProtection);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        String materialStr = (String)sCommandToExec.getSettingValue("material");
        boolean bypassProtection = (Boolean)sCommandToExec.getSettingValue("bypassProtection");
        Material material = null;
        try {
            material = Material.valueOf((String)materialStr.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TreeSet<Material> set = new TreeSet<Material>();
        set.add(Material.WATER);
        set.add(Material.LAVA);
        set.add(Material.AIR);
        Block block = receiver.getTargetBlock(set, 5);
        if (block.getType() != Material.AIR) {
            RayTraceResult result;
            BlockFace blockFace = (BlockFace)sCommandToExec.getSettingValue("blockface");
            if (blockFace == null && (result = receiver.getLocation().getWorld().rayTraceBlocks(receiver.getEyeLocation(), receiver.getEyeLocation().getDirection(), 5.0)) != null) {
                blockFace = result.getHitBlockFace();
            }
            if (blockFace == null) {
                return;
            }
            block = block.getRelative(blockFace);
            UUID uuid = receiver.getUniqueId();
            if (!bypassProtection && !SafePlace.verifSafePlace(uuid, block)) {
                return;
            }
            if (material != null) {
                SafePlace.placeBlockWithEvent(block, material, Optional.empty(), uuid, false, true);
            } else {
                if (!SafePlace.verifSafePlace(uuid, block)) {
                    return;
                }
                RunConsoleCommand.runConsoleCommand("execute at " + receiver.getName() + " run setblock " + block.getX() + " " + block.getY() + " " + block.getZ() + " " + materialStr.toLowerCase(), sCommandToExec.getActionInfo().isSilenceOutput());
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SET_BLOCK");
        names.add("SETBLOCK");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SET_BLOCK material:STONE blockface:UP bypassProtection:true";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

