/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SetItemName
extends PlayerCommand {
    public SetItemName() {
        CommandSetting slot = new CommandSetting("slot", 0, Integer.class, (Object)-1);
        slot.setSlot(true);
        CommandSetting name = new CommandSetting("name", 1, String.class, (Object)"&eNew_name");
        List<CommandSetting> settings = this.getSettings();
        settings.add(slot);
        settings.add(name);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        String name = (String)sCommandToExec.getSettingValue("name");
        int slot = (Integer)sCommandToExec.getSettingValue("slot");
        ItemStack item = slot == -1 ? receiver.getInventory().getItemInMainHand() : receiver.getInventory().getItem(slot);
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (!item.hasItemMeta()) {
            item.setItemMeta(new ItemStack(item.getType()).getItemMeta());
        }
        ItemMeta itemmeta = item.getItemMeta();
        StringBuilder build = new StringBuilder(name);
        for (String s : sCommandToExec.getOtherArgs()) {
            build.append(" ").append(s);
        }
        itemmeta.setDisplayName(StringConverter.coloredString(build.toString()));
        item.setItemMeta(itemmeta);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SET_ITEM_NAME");
        names.add("SETITEMNAME");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SET_ITEM_NAME slot:-1 name:&eNew_name";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

