/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands.openchest;

import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.commands.runnable.player.commands.openchest.OpenChestManager;
import com.ssomar.score.utils.numbers.NTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Barrel;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class OpenChest
extends PlayerCommand {
    private static OpenChest instance;
    private Map<Player, Inventory> bypassChests = new HashMap<Player, Inventory>();

    private OpenChest() {
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        World world = Bukkit.getWorld((String)args.get(0));
        if (world == null) {
            return;
        }
        Double x = NTools.getDouble(args.get(1)).get();
        Double y = NTools.getDouble(args.get(2)).get();
        Double z = NTools.getDouble(args.get(3)).get();
        boolean bypassProtections = false;
        if (args.size() > 4) {
            bypassProtections = Boolean.parseBoolean(args.get(4));
        }
        Location location = new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue());
        Chunk chunk = location.getChunk();
        BlockState state = location.getBlock().getState();
        if (state instanceof Chest) {
            Chest chest = (Chest)location.getBlock().getState();
            InventoryHolder holder = chest.getInventory().getHolder();
            Inventory chestInventory = chest.getInventory();
            if (holder instanceof DoubleChest) {
                chestInventory = ((DoubleChest)holder).getInventory();
            }
            if (bypassProtections) {
                this.bypassChests.put(receiver, chestInventory);
            }
            receiver.openInventory(chestInventory);
        } else if (state instanceof Barrel) {
            Barrel barrel = (Barrel)location.getBlock().getState();
            Inventory barrelInventory = barrel.getInventory();
            if (bypassProtections) {
                this.bypassChests.put(receiver, barrelInventory);
            }
            receiver.openInventory(barrelInventory);
        } else {
            return;
        }
        OpenChestManager.getInstance().addForcedChunk(chunk, receiver.getUniqueId());
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        ArgumentChecker ac4;
        if (args.size() < 4) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + this.getTemplate());
        }
        ArgumentChecker ac = OpenChest.checkInteger(args.get(1), isFinalVerification, this.getTemplate());
        if (!ac.isValid()) {
            return Optional.of(ac.getError());
        }
        ArgumentChecker ac2 = OpenChest.checkInteger(args.get(2), isFinalVerification, this.getTemplate());
        if (!ac2.isValid()) {
            return Optional.of(ac.getError());
        }
        ArgumentChecker ac3 = OpenChest.checkInteger(args.get(3), isFinalVerification, this.getTemplate());
        if (!ac3.isValid()) {
            return Optional.of(ac.getError());
        }
        if (args.size() > 4 && !(ac4 = OpenChest.checkBoolean(args.get(4), isFinalVerification, this.getTemplate())).isValid()) {
            return Optional.of(ac.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("OPEN_CHEST");
        names.add("OPENCHEST");
        return names;
    }

    @Override
    public String getTemplate() {
        return "OPENCHEST {world} {x} {y} {z} [bypassProtections]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }

    public static OpenChest getInstance() {
        if (instance == null) {
            instance = new OpenChest();
        }
        return instance;
    }

    @Generated
    public Map<Player, Inventory> getBypassChests() {
        return this.bypassChests;
    }
}

