/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.score;

import com.ssomar.score.commands.score.CustomCommandWithManagerAbstract;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectManager;
import com.ssomar.score.sobject.SObjectWithFileEditable;
import com.ssomar.score.splugin.SPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class PathCommand<X extends SPlugin, Y extends SObjectManager<Z>, Z extends SObjectWithFileEditable>
extends CustomCommandWithManagerAbstract<X, Y, Z> {
    public PathCommand(X sPlugin, Y sObjectManager) {
        super(sPlugin, sObjectManager);
    }

    @Override
    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("path");
        return commands;
    }

    @Override
    public void run(CommandSender sender, String command, String[] args, String typedCommand) {
        switch (command) {
            case "path": {
                if (args.length >= 1) {
                    ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
                    String eiID = (String)arguments.get(0);
                    Optional obj = ((SObjectManager)this.getSObjectManager()).getLoadedObjectWithID(eiID);
                    if (!obj.isPresent()) {
                        this.getSm().sendMessage(sender, ChatColor.RED + this.getSPlugin().getNameWithBrackets() + " &cNo object found with ID: " + eiID);
                        return;
                    }
                    SObjectWithFileEditable sObject = (SObjectWithFileEditable)obj.get();
                    if (!(sObject instanceof SObjectWithFileEditable)) {
                        this.getSm().sendMessage(sender, ChatColor.RED + this.getSPlugin().getNameWithBrackets() + " &cThe object with ID: " + eiID + " has no file linked.");
                        return;
                    }
                    SObjectWithFileEditable sObjectWithFileEditable = sObject;
                    this.getSm().sendMessage(sender, ChatColor.GREEN + this.getSPlugin().getNameWithBrackets() + " &aThe path of &e" + sObject.getId() + " &ais &e" + sObjectWithFileEditable.getPath() + "&a.");
                    break;
                }
                this.getSm().sendMessage(sender, ChatColor.RED + this.getSPlugin().getNameWithBrackets() + " &cNot enough args /" + this.getSPlugin().getShortName().toLowerCase() + " {id}");
            }
        }
    }

    @Override
    public List<String> getArguments(String command, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        switch (args[0]) {
            case "path": {
                for (SObject item : ((SObjectManager)this.getSObjectManager()).getLoadedObjects()) {
                    arguments.add(item.getId());
                }
                Collections.sort(arguments);
                return arguments;
            }
        }
        return arguments;
    }
}

