/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.configs.messages;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class MessageMain {
    private static MessageMain instance;
    private String fileName = "";
    private Map<Plugin, Map<MessageInterface, String>> messages = new HashMap<Plugin, Map<MessageInterface, String>>();

    public static MessageMain getInstance() {
        if (instance == null) {
            instance = new MessageMain();
        }
        return instance;
    }

    public void load() {
        this.messages = new HashMap<Plugin, Map<MessageInterface, String>>();
        Utils.sendConsoleMsg("&eSCore &7Language for in-game messages setup on &6" + (Object)((Object)GeneralConfig.getInstance().getLocale()));
        this.fileName = "/locale/Locale_" + (Object)((Object)GeneralConfig.getInstance().getLocale()) + ".yml";
    }

    public void reload() {
        Utils.sendConsoleMsg("&eSCore &7Language for in-game messages setup on &6" + (Object)((Object)GeneralConfig.getInstance().getLocale()));
        this.fileName = "/locale/Locale_" + (Object)((Object)GeneralConfig.getInstance().getLocale()) + ".yml";
        for (Plugin plugin : this.messages.keySet()) {
            Map<MessageInterface, String> formMessages = this.messages.get(plugin);
            this.loadMessagesOf(plugin, Arrays.asList(formMessages.keySet().toArray(new MessageInterface[0])));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMessagesOf(Plugin plugin, List<MessageInterface> messagesEnum) {
        File pdfile;
        HashMap<MessageInterface, String> formMessages = new HashMap<MessageInterface, String>();
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdir();
        }
        if (!(pdfile = new File(plugin.getDataFolder(), this.fileName)).exists()) {
            try {
                pdfile.getParentFile().mkdir();
                pdfile.createNewFile();
                BufferedReader br = new BufferedReader(new InputStreamReader(plugin.getResource(this.fileName)));
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pdfile), StandardCharsets.UTF_8));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        out.write(line);
                        out.write("\n");
                    }
                }
                finally {
                    br.close();
                    ((Writer)out).close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create the file: " + this.fileName + " for the plugin: " + plugin.getName(), e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)pdfile);
        for (MessageInterface msgI : messagesEnum) {
            formMessages.put(msgI, this.loadMessage(plugin, pdfile, (FileConfiguration)config, msgI.getName()));
        }
        this.messages.put(plugin, formMessages);
    }

    public String loadMessage(Plugin plugin, File pdFile, FileConfiguration config, String message) {
        if (config.getString(message) != null) {
            return StringConverter.coloredString(config.getString(message));
        }
        return StringConverter.coloredString(this.write(plugin, pdFile, config, message));
    }

    public String write(Plugin plugin, File pdFile, FileConfiguration config, String what) {
        String insert = "Can't load the string (" + what + ") for the plugin > " + plugin.getName() + " in language: " + (Object)((Object)GeneralConfig.getInstance().getLocale()) + ", contact the developer";
        try {
            String ligne;
            InputStream flux = plugin.getClass().getResourceAsStream("/com/ssomar/" + plugin.getName().toLowerCase() + "/configs/locale/Locale_" + (Object)((Object)GeneralConfig.getInstance().getLocale()) + ".yml");
            if (flux == null) {
                Utils.sendConsoleMsg("&eSCore &cERROR LOAD MESSAGE &6" + what + " &cfor the plugin > &6" + plugin.getName() + " &cin language: &6" + (Object)((Object)GeneralConfig.getInstance().getLocale()) + " &c(File in jar not found");
                return insert;
            }
            InputStreamReader lecture = new InputStreamReader(flux, StandardCharsets.UTF_8);
            BufferedReader buff = new BufferedReader(lecture);
            boolean isNotUpdate = true;
            while ((ligne = buff.readLine()) != null && isNotUpdate) {
                if (!ligne.contains(what + ":")) continue;
                Utils.sendConsoleMsg("&eSCore &7Update of &6" + what + " &7in your for the plugin > &6" + plugin.getName() + " &7in language: &6" + (Object)((Object)GeneralConfig.getInstance().getLocale()));
                String[] split = ligne.split("\"");
                insert = split.length > 1 ? split[1] : "";
                config.set(what, (Object)insert);
                config.save(pdFile);
                isNotUpdate = false;
            }
            buff.close();
            if (isNotUpdate) {
                Utils.sendConsoleMsg("&eSCore &cERROR LOAD MESSAGE &6" + what + " &cfor the plugin > &6" + plugin.getName() + " &cin language: &6" + (Object)((Object)GeneralConfig.getInstance().getLocale()) + " (Message not found in jar)");
            }
        }
        catch (Exception e) {
            Utils.sendConsoleMsg("&eSCore &cERROR LOAD MESSAGE &6" + what + " &cfor the plugin > &6" + plugin.getName() + " &cin language: &6" + (Object)((Object)GeneralConfig.getInstance().getLocale()));
            e.printStackTrace();
        }
        return insert;
    }

    public String getMessage(Plugin plugin, MessageInterface message) {
        if (this.messages.containsKey(plugin) && this.messages.get(plugin).containsKey(message)) {
            return this.messages.get(plugin).get(message);
        }
        return "";
    }
}

