/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureForBlock;
import com.ssomar.score.features.FeatureForBlockArgs;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.list.ListUncoloredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.numbers.NTools;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityFactory;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ItemSpawnerFeature
extends FeatureWithHisOwnEditor<ItemSpawnerFeature, ItemSpawnerFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItem,
FeatureForBlock {
    private IntegerFeature spawnCount;
    private IntegerFeature spawnDelay;
    private IntegerFeature spawnRange;
    private IntegerFeature requiredPlayerRange;
    private IntegerFeature minSpawnDelay;
    private IntegerFeature maxSpawnDelay;
    private IntegerFeature maxNearbyEntities;
    private ListUncoloredStringFeature potentialSpawns;
    private BooleanFeature addSpawnerNbtToItem;

    public ItemSpawnerFeature(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.spawnerFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.spawnDelay = new IntegerFeature(this, Optional.of(0), FeatureSettingsSCore.spawnDelay);
        this.spawnRange = new IntegerFeature(this, Optional.of(4), FeatureSettingsSCore.spawnRange);
        this.requiredPlayerRange = new IntegerFeature(this, Optional.of(16), FeatureSettingsSCore.requiredPlayerRange);
        this.minSpawnDelay = new IntegerFeature(this, Optional.of(200), FeatureSettingsSCore.minSpawnDelay);
        this.maxSpawnDelay = new IntegerFeature(this, Optional.of(800), FeatureSettingsSCore.maxSpawnDelay);
        this.spawnCount = new IntegerFeature(this, Optional.of(4), FeatureSettingsSCore.spawnCount);
        this.maxNearbyEntities = new IntegerFeature(this, Optional.of(6), FeatureSettingsSCore.maxNearbyEntities);
        this.potentialSpawns = new ListUncoloredStringFeature((FeatureParentInterface)this, new ArrayList<String>(), FeatureSettingsSCore.potentialSpawns, Optional.empty());
        this.addSpawnerNbtToItem = new BooleanFeature(this, false, FeatureSettingsSCore.addSpawnerNbtToItem);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            errors.addAll(this.spawnCount.load(plugin, section, isPremiumLoading));
            errors.addAll(this.minSpawnDelay.load(plugin, section, isPremiumLoading));
            errors.addAll(this.maxSpawnDelay.load(plugin, section, isPremiumLoading));
            errors.addAll(this.spawnDelay.load(plugin, section, isPremiumLoading));
            errors.addAll(this.spawnRange.load(plugin, section, isPremiumLoading));
            errors.addAll(this.requiredPlayerRange.load(plugin, section, isPremiumLoading));
            errors.addAll(this.maxNearbyEntities.load(plugin, section, isPremiumLoading));
            errors.addAll(this.potentialSpawns.load(plugin, section, isPremiumLoading));
            errors.addAll(this.addSpawnerNbtToItem.load(plugin, section, isPremiumLoading));
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.spawnCount.save(section);
        this.spawnDelay.save(section);
        this.spawnRange.save(section);
        this.requiredPlayerRange.save(section);
        this.minSpawnDelay.save(section);
        this.maxSpawnDelay.save(section);
        this.maxNearbyEntities.save(section);
        this.potentialSpawns.save(section);
        this.addSpawnerNbtToItem.save(section);
    }

    @Override
    public ItemSpawnerFeature getValue() {
        return this;
    }

    @Override
    public ItemSpawnerFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 8];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 8] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 7] = "&7Spawn Count: &e" + ((Optional)this.spawnCount.getValue()).orElse(0);
        finalDescription[finalDescription.length - 6] = "&7Spawn Delay: &e" + ((Optional)this.spawnDelay.getValue()).orElse(0);
        finalDescription[finalDescription.length - 5] = "&7Spawn Range: &e" + ((Optional)this.spawnRange.getValue()).orElse(0);
        finalDescription[finalDescription.length - 4] = "&7Required Player Range: &e" + ((Optional)this.requiredPlayerRange.getValue()).orElse(0);
        finalDescription[finalDescription.length - 3] = "&7Max Nearby Entities: &e" + ((Optional)this.maxNearbyEntities.getValue()).orElse(0);
        finalDescription[finalDescription.length - 2] = "&7Potential Spawns: &e" + this.potentialSpawns.getValue().size();
        finalDescription[finalDescription.length - 1] = "&7Add Spawner NBT to Item: &e" + this.addSpawnerNbtToItem.getValue();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ItemSpawnerFeature clone(FeatureParentInterface newParent) {
        ItemSpawnerFeature clone = new ItemSpawnerFeature(newParent);
        clone.setSpawnCount(this.spawnCount.clone(clone));
        clone.setMinSpawnDelay(this.minSpawnDelay.clone(clone));
        clone.setMaxSpawnDelay(this.maxSpawnDelay.clone(clone));
        clone.setSpawnDelay(this.spawnDelay.clone(clone));
        clone.setSpawnRange(this.spawnRange.clone(clone));
        clone.setRequiredPlayerRange(this.requiredPlayerRange.clone(clone));
        clone.setMaxNearbyEntities(this.maxNearbyEntities.clone(clone));
        clone.setPotentialSpawns(this.potentialSpawns.clone(clone));
        clone.setAddSpawnerNbtToItem(this.addSpawnerNbtToItem.clone(clone));
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.spawnCount);
        features.add(this.spawnDelay);
        features.add(this.spawnRange);
        features.add(this.requiredPlayerRange);
        features.add(this.minSpawnDelay);
        features.add(this.maxSpawnDelay);
        features.add(this.maxNearbyEntities);
        features.add(this.potentialSpawns);
        features.add(this.addSpawnerNbtToItem);
        return features;
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v20v4Plus();
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof ItemSpawnerFeature)) continue;
            ItemSpawnerFeature spawnerFeature = (ItemSpawnerFeature)feature;
            spawnerFeature.setSpawnDelay(this.spawnDelay);
            spawnerFeature.setMinSpawnDelay(this.minSpawnDelay);
            spawnerFeature.setMaxSpawnDelay(this.maxSpawnDelay);
            spawnerFeature.setSpawnCount(this.spawnCount);
            spawnerFeature.setSpawnRange(this.spawnRange);
            spawnerFeature.setRequiredPlayerRange(this.requiredPlayerRange);
            spawnerFeature.setMaxNearbyEntities(this.maxNearbyEntities);
            spawnerFeature.setPotentialSpawns(this.potentialSpawns);
            spawnerFeature.setAddSpawnerNbtToItem(this.addSpawnerNbtToItem);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForBlockArgs args) {
        return args.getBlockState() instanceof CreatureSpawner;
    }

    @Override
    public void applyOnBlockData(@NotNull FeatureForBlockArgs args) {
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        CreatureSpawner spawner = (CreatureSpawner)args.getBlockState();
        if (((Optional)this.spawnCount.getValue()).isPresent()) {
            spawner.setSpawnCount(((Integer)((Optional)this.spawnCount.getValue()).get()).intValue());
        }
        if (((Optional)this.minSpawnDelay.getValue()).isPresent()) {
            spawner.setMinSpawnDelay(((Integer)((Optional)this.minSpawnDelay.getValue()).get()).intValue());
        }
        if (((Optional)this.maxSpawnDelay.getValue()).isPresent()) {
            spawner.setMaxSpawnDelay(((Integer)((Optional)this.maxSpawnDelay.getValue()).get()).intValue());
        }
        if (((Optional)this.spawnDelay.getValue()).isPresent()) {
            spawner.setDelay(((Integer)((Optional)this.spawnDelay.getValue()).get()).intValue());
        }
        if (((Optional)this.spawnRange.getValue()).isPresent()) {
            spawner.setSpawnRange(((Integer)((Optional)this.spawnRange.getValue()).get()).intValue());
        }
        if (((Optional)this.requiredPlayerRange.getValue()).isPresent()) {
            spawner.setRequiredPlayerRange(((Integer)((Optional)this.requiredPlayerRange.getValue()).get()).intValue());
        }
        if (((Optional)this.maxNearbyEntities.getValue()).isPresent()) {
            spawner.setMaxNearbyEntities(((Integer)((Optional)this.maxNearbyEntities.getValue()).get()).intValue());
        }
        if (!this.potentialSpawns.getValue().isEmpty()) {
            ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
            EntityFactory entityFactory = Bukkit.getEntityFactory();
            Iterator iterator = this.potentialSpawns.getValue().iterator();
            while (iterator.hasNext()) {
                Optional<Integer> optionalWeight;
                String potentialSpawn = (String)iterator.next();
                String[] split = potentialSpawn.split(";");
                EntitySnapshot snapshot = entityFactory.createEntitySnapshot(split[0]);
                int weight = 1;
                if (split.length > 1 && (optionalWeight = NTools.getInteger(split[1])).isPresent()) {
                    weight = optionalWeight.get();
                }
                entries.add(new SpawnerEntry(snapshot, weight, null));
            }
            spawner.setPotentialSpawns(entries);
        }
        spawner.update();
    }

    @Override
    public void loadFromBlockData(@NotNull FeatureForBlockArgs args) {
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        CreatureSpawner spawner = (CreatureSpawner)args.getBlockState();
        this.spawnDelay.setValue(Optional.of(spawner.getDelay()));
        this.spawnRange.setValue(Optional.of(spawner.getSpawnRange()));
        this.requiredPlayerRange.setValue(Optional.of(spawner.getRequiredPlayerRange()));
        this.maxNearbyEntities.setValue(Optional.of(spawner.getMaxNearbyEntities()));
        this.spawnCount.setValue(Optional.of(spawner.getSpawnCount()));
        this.minSpawnDelay.setValue(Optional.of(spawner.getMinSpawnDelay()));
        this.maxSpawnDelay.setValue(Optional.of(spawner.getMaxSpawnDelay()));
        List entries = spawner.getPotentialSpawns();
        ArrayList<String> types = new ArrayList<String>();
        for (SpawnerEntry entry : entries) {
            String snapshot = entry.getSnapshot().getAsString();
            int weight = entry.getSpawnWeight();
            types.add(snapshot + ";" + weight);
        }
        this.potentialSpawns.setValues(types);
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
        BlockState blockState = blockStateMeta.getBlockState();
        if (!(blockState instanceof CreatureSpawner)) {
            return;
        }
        CreatureSpawner spawner = (CreatureSpawner)blockState;
        this.spawnDelay.setValue(Optional.of(spawner.getDelay()));
        this.spawnRange.setValue(Optional.of(spawner.getSpawnRange()));
        this.requiredPlayerRange.setValue(Optional.of(spawner.getRequiredPlayerRange()));
        this.maxNearbyEntities.setValue(Optional.of(spawner.getMaxNearbyEntities()));
        this.spawnCount.setValue(Optional.of(spawner.getSpawnCount()));
        this.minSpawnDelay.setValue(Optional.of(spawner.getMinSpawnDelay()));
        this.maxSpawnDelay.setValue(Optional.of(spawner.getMaxSpawnDelay()));
        List entries = spawner.getPotentialSpawns();
        ArrayList<String> types = new ArrayList<String>();
        for (SpawnerEntry entry : entries) {
            String snapshot = entry.getSnapshot().getAsString();
            int weight = entry.getSpawnWeight();
            types.add(snapshot + ";" + weight);
        }
        this.potentialSpawns.setValues(types);
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return args.getMeta() instanceof BlockStateMeta && ((BlockStateMeta)args.getMeta()).getBlockState() instanceof CreatureSpawner;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        if (!this.addSpawnerNbtToItem.getValue().booleanValue()) {
            return;
        }
        BlockStateMeta meta = (BlockStateMeta)args.getMeta();
        CreatureSpawner spawner = (CreatureSpawner)meta.getBlockState();
        if (((Optional)this.spawnCount.getValue()).isPresent()) {
            spawner.setSpawnCount(((Integer)((Optional)this.spawnCount.getValue()).get()).intValue());
        }
        if (((Optional)this.minSpawnDelay.getValue()).isPresent()) {
            spawner.setMinSpawnDelay(((Integer)((Optional)this.minSpawnDelay.getValue()).get()).intValue());
        }
        if (((Optional)this.maxSpawnDelay.getValue()).isPresent()) {
            spawner.setMaxSpawnDelay(((Integer)((Optional)this.maxSpawnDelay.getValue()).get()).intValue());
        }
        if (((Optional)this.spawnDelay.getValue()).isPresent()) {
            spawner.setDelay(((Integer)((Optional)this.spawnDelay.getValue()).get()).intValue());
        }
        if (((Optional)this.spawnRange.getValue()).isPresent()) {
            spawner.setSpawnRange(((Integer)((Optional)this.spawnRange.getValue()).get()).intValue());
        }
        if (((Optional)this.requiredPlayerRange.getValue()).isPresent()) {
            spawner.setRequiredPlayerRange(((Integer)((Optional)this.requiredPlayerRange.getValue()).get()).intValue());
        }
        if (((Optional)this.maxNearbyEntities.getValue()).isPresent()) {
            spawner.setMaxNearbyEntities(((Integer)((Optional)this.maxNearbyEntities.getValue()).get()).intValue());
        }
        if (!this.potentialSpawns.getValue().isEmpty()) {
            ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
            EntityFactory entityFactory = Bukkit.getEntityFactory();
            Iterator iterator = this.potentialSpawns.getValue().iterator();
            while (iterator.hasNext()) {
                Optional<Integer> optionalWeight;
                String potentialSpawn = (String)iterator.next();
                String[] split = potentialSpawn.split(";");
                EntitySnapshot snapshot = entityFactory.createEntitySnapshot(split[0]);
                int weight = 1;
                if (split.length > 1 && (optionalWeight = NTools.getInteger(split[1])).isPresent()) {
                    weight = optionalWeight.get();
                }
                entries.add(new SpawnerEntry(snapshot, weight, null));
            }
            spawner.setPotentialSpawns(entries);
        }
        meta.setBlockState((BlockState)spawner);
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.SPAWNER;
    }

    @Generated
    public IntegerFeature getSpawnCount() {
        return this.spawnCount;
    }

    @Generated
    public IntegerFeature getSpawnDelay() {
        return this.spawnDelay;
    }

    @Generated
    public IntegerFeature getSpawnRange() {
        return this.spawnRange;
    }

    @Generated
    public IntegerFeature getRequiredPlayerRange() {
        return this.requiredPlayerRange;
    }

    @Generated
    public IntegerFeature getMinSpawnDelay() {
        return this.minSpawnDelay;
    }

    @Generated
    public IntegerFeature getMaxSpawnDelay() {
        return this.maxSpawnDelay;
    }

    @Generated
    public IntegerFeature getMaxNearbyEntities() {
        return this.maxNearbyEntities;
    }

    @Generated
    public ListUncoloredStringFeature getPotentialSpawns() {
        return this.potentialSpawns;
    }

    @Generated
    public BooleanFeature getAddSpawnerNbtToItem() {
        return this.addSpawnerNbtToItem;
    }

    @Generated
    public void setSpawnCount(IntegerFeature spawnCount) {
        this.spawnCount = spawnCount;
    }

    @Generated
    public void setSpawnDelay(IntegerFeature spawnDelay) {
        this.spawnDelay = spawnDelay;
    }

    @Generated
    public void setSpawnRange(IntegerFeature spawnRange) {
        this.spawnRange = spawnRange;
    }

    @Generated
    public void setRequiredPlayerRange(IntegerFeature requiredPlayerRange) {
        this.requiredPlayerRange = requiredPlayerRange;
    }

    @Generated
    public void setMinSpawnDelay(IntegerFeature minSpawnDelay) {
        this.minSpawnDelay = minSpawnDelay;
    }

    @Generated
    public void setMaxSpawnDelay(IntegerFeature maxSpawnDelay) {
        this.maxSpawnDelay = maxSpawnDelay;
    }

    @Generated
    public void setMaxNearbyEntities(IntegerFeature maxNearbyEntities) {
        this.maxNearbyEntities = maxNearbyEntities;
    }

    @Generated
    public void setPotentialSpawns(ListUncoloredStringFeature potentialSpawns) {
        this.potentialSpawns = potentialSpawns;
    }

    @Generated
    public void setAddSpawnerNbtToItem(BooleanFeature addSpawnerNbtToItem) {
        this.addSpawnerNbtToItem = addSpawnerNbtToItem;
    }
}

