/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.item.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.item.ItemConditionFeature;
import com.ssomar.score.features.custom.conditions.item.ItemConditionRequest;
import com.ssomar.score.features.types.list.ListEnchantAndLevelFeature;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class IfHasNotEnchant
extends ItemConditionFeature<ListEnchantAndLevelFeature, IfHasNotEnchant> {
    public IfHasNotEnchant(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifHasNotEnchant);
    }

    @Override
    public boolean verifCondition(ItemConditionRequest request) {
        if (this.hasCondition()) {
            ItemStack itemStack = request.getItemStack();
            ItemMeta itemMeta = null;
            boolean hasItemMeta = itemStack.hasItemMeta();
            if (hasItemMeta) {
                itemMeta = itemStack.getItemMeta();
            }
            if (!hasItemMeta) {
                this.runInvalidCondition(request);
                return false;
            }
            Map enchants = itemMeta.getEnchants();
            Object condition = ((ListEnchantAndLevelFeature)this.getCondition()).getValue();
            for (Enchantment enchant : condition.keySet()) {
                if (!enchants.containsKey(enchant) || !((Integer)condition.get(enchant)).equals(enchants.get(enchant))) continue;
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfHasNotEnchant getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new ListEnchantAndLevelFeature(this, new HashMap<Enchantment, Integer>(), FeatureSettingsSCore.ifHasNotEnchant, true));
    }

    @Override
    public boolean hasCondition() {
        return ((ListEnchantAndLevelFeature)this.getCondition()).getValue().size() > 0;
    }

    @Override
    public IfHasNotEnchant getNewInstance(FeatureParentInterface parent) {
        return new IfHasNotEnchant(parent);
    }
}

