/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.types.NumberConditionFeature;
import com.ssomar.score.utils.strings.StringCalculation;
import java.util.Optional;
import org.bukkit.entity.Player;

public class IfPlayerLastDamage
extends PlayerConditionFeature<NumberConditionFeature, IfPlayerLastDamage> {
    public IfPlayerLastDamage(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifPlayerLastDamage);
    }

    @Override
    public boolean verifCondition(PlayerConditionRequest request) {
        if (this.hasCondition()) {
            Player player = request.getPlayer();
            double lastDamage = player.getLastDamage();
            if (!StringCalculation.calculation(((NumberConditionFeature)this.getCondition()).getValue(Optional.of(player), request.getSp()).get(), lastDamage)) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfPlayerLastDamage getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new NumberConditionFeature(this.getParent(), FeatureSettingsSCore.ifPlayerLastDamage));
    }

    @Override
    public boolean hasCondition() {
        return ((Optional)((NumberConditionFeature)this.getCondition()).getValue()).isPresent();
    }

    @Override
    public IfPlayerLastDamage getNewInstance(FeatureParentInterface parent) {
        return new IfPlayerLastDamage(parent);
    }
}

