/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.drop;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ChatColorFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DropFeatures
extends FeatureWithHisOwnEditor<DropFeatures, DropFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private BooleanFeature glowDrop;
    private ChatColorFeature dropColor;
    private BooleanFeature displayNameDrop;

    public DropFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.dropFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.glowDrop = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.glowDrop);
        this.dropColor = new ChatColorFeature(this.getParent(), Optional.of(ChatColor.WHITE), FeatureSettingsSCore.glowDropColor);
        this.displayNameDrop = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.displayNameDrop);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            this.glowDrop.load(plugin, section, isPremiumLoading);
            if (this.glowDrop.getValue().booleanValue() && SCore.is1v11Less()) {
                error.add(plugin.getNameDesign() + " " + this.getParent().getParentInfo() + " glowDrop is not supported in 1.11, 1.10, 1.9, 1.8 !");
                this.glowDrop.setValue(false);
            }
            if (!SCore.is1v11Less()) {
                this.dropColor.load(plugin, section, isPremiumLoading);
            }
            this.displayNameDrop.load(plugin, section, isPremiumLoading);
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.glowDrop.save(section);
        this.dropColor.save(section);
        this.displayNameDrop.save(section);
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public DropFeatures getValue() {
        return this;
    }

    @Override
    public DropFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = SCore.is1v11Less() ? "&7Glow drop: &c&lNot for 1.11 or lower" : (this.glowDrop.getValue() != false ? "&7Glow drop: &a&l\u2714" : "&7Glow drop: &c&l\u2718");
        finalDescription[finalDescription.length - 2] = SCore.is1v11Less() ? "&7Glow drop color: &c&lNot for 1.11 or lower" : (((Optional)this.dropColor.getValue()).isPresent() ? "&7Glow drop color: &e" + ((ChatColor)((Optional)this.dropColor.getValue()).get()).name() : "&7Glow drop color: &c&l\u2718");
        finalDescription[finalDescription.length - 1] = this.displayNameDrop.getValue() != false ? "&7Display custom name: &a&l\u2714" : "&7Display custom name: &c&l\u2718";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public DropFeatures clone(FeatureParentInterface newParent) {
        DropFeatures dropFeatures = new DropFeatures(newParent);
        dropFeatures.setGlowDrop(this.glowDrop.clone(dropFeatures));
        dropFeatures.setDropColor(this.dropColor.clone(dropFeatures));
        dropFeatures.setDisplayNameDrop(this.displayNameDrop.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        if (!SCore.is1v11Less()) {
            features.add(this.glowDrop);
            features.add(this.dropColor);
        }
        features.add(this.displayNameDrop);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof DropFeatures)) continue;
            DropFeatures dropFeatures = (DropFeatures)feature;
            dropFeatures.setGlowDrop(this.glowDrop);
            dropFeatures.setDropColor(this.dropColor);
            dropFeatures.setDisplayNameDrop(this.displayNameDrop);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public BooleanFeature getGlowDrop() {
        return this.glowDrop;
    }

    @Generated
    public ChatColorFeature getDropColor() {
        return this.dropColor;
    }

    @Generated
    public BooleanFeature getDisplayNameDrop() {
        return this.displayNameDrop;
    }

    @Generated
    public void setGlowDrop(BooleanFeature glowDrop) {
        this.glowDrop = glowDrop;
    }

    @Generated
    public void setDropColor(ChatColorFeature dropColor) {
        this.dropColor = dropColor;
    }

    @Generated
    public void setDisplayNameDrop(BooleanFeature displayNameDrop) {
        this.displayNameDrop = displayNameDrop;
    }
}

