/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.firework.explosion.group;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.firework.explosion.FireworkExplosionFeatures;
import com.ssomar.score.features.custom.firework.explosion.group.FireworkExplosionGroupFeatureEditor;
import com.ssomar.score.features.custom.firework.explosion.group.FireworkExplosionGroupFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class FireworkExplosionGroupFeature
extends FeatureWithHisOwnEditor<FireworkExplosionGroupFeature, FireworkExplosionGroupFeature, FireworkExplosionGroupFeatureEditor, FireworkExplosionGroupFeatureEditorManager>
implements FeaturesGroup<FireworkExplosionFeatures>,
FeatureForItem {
    private Map<String, FireworkExplosionFeatures> explosions;
    private boolean notSaveIfNoValue;
    int premiumLimit = 99;

    public FireworkExplosionGroupFeature(FeatureParentInterface parent, boolean notSaveIfNoValue) {
        super(parent, FeatureSettingsSCore.fireworkExplosions);
        this.notSaveIfNoValue = notSaveIfNoValue;
        this.reset();
    }

    @Override
    public void reset() {
        this.explosions = new LinkedHashMap<String, FireworkExplosionFeatures>();
    }

    public void transformTheProjectile(Entity e, Player launcher, Material materialLaunched) {
        if (e instanceof Firework) {
            Firework firework = (Firework)e;
            FireworkMeta meta = firework.getFireworkMeta();
            if (this.explosions.isEmpty()) {
                return;
            }
            ArrayList<FireworkEffect> effects = new ArrayList<FireworkEffect>();
            for (FireworkExplosionFeatures explosion : this.explosions.values()) {
                if (explosion.getColors().getValue().isEmpty() || !((Optional)explosion.getType().getValue()).isPresent()) continue;
                FireworkEffect.Builder builder = FireworkEffect.builder();
                if (explosion.getHasTrail().getValue().booleanValue()) {
                    builder.withTrail();
                }
                if (explosion.getHasTwinkle().getValue().booleanValue()) {
                    builder.withFlicker();
                }
                if (!explosion.getFadeColors().getValue().isEmpty()) {
                    builder.withFade((Iterable)explosion.getFadeColors().getValue());
                }
                builder.with((FireworkEffect.Type)((Optional)explosion.getType().getValue()).get());
                builder.withColor((Iterable)explosion.getColors().getValue());
                effects.add(builder.build());
            }
            for (FireworkEffect effect : effects) {
                meta.addEffect(effect);
            }
            firework.setFireworkMeta(meta);
        }
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String explosionId : enchantmentsSection.getKeys(false)) {
                if (this.explosions.size() >= this.premiumLimit && !this.isPremium()) {
                    error.add("&cERROR, Couldn't load the Explosion of " + explosionId + " from config, &7&o" + this.getParent().getParentInfo() + " &6>> Because it requires the premium version to have more than 99 explosions !");
                    return error;
                }
                FireworkExplosionFeatures attribute = new FireworkExplosionFeatures((FeatureParentInterface)this, explosionId);
                List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.explosions.put(explosionId, attribute);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfNoValue && this.explosions.isEmpty()) {
            return;
        }
        ConfigurationSection explosionsSection = config.createSection(this.getName());
        for (String explosionId : this.explosions.keySet()) {
            this.explosions.get(explosionId).save(explosionsSection);
        }
    }

    @Override
    public FireworkExplosionGroupFeature getValue() {
        return this;
    }

    @Override
    public FireworkExplosionGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oExplosion(s) added: &e" + this.explosions.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public FireworkExplosionFeatures getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (FireworkExplosionFeatures x : this.explosions.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public FireworkExplosionGroupFeature clone(FeatureParentInterface newParent) {
        FireworkExplosionGroupFeature eF = new FireworkExplosionGroupFeature(newParent, this.isNotSaveIfNoValue());
        LinkedHashMap<String, FireworkExplosionFeatures> newAttributes = new LinkedHashMap<String, FireworkExplosionFeatures>();
        for (String x : this.explosions.keySet()) {
            newAttributes.put(x, this.explosions.get(x).clone(eF));
        }
        eF.setExplosions(newAttributes);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>(this.explosions.values());
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof FireworkExplosionGroupFeature)) continue;
            FireworkExplosionGroupFeature eF = (FireworkExplosionGroupFeature)feature;
            eF.setExplosions(this.explosions);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        FireworkExplosionGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        if (!this.isPremium() && this.explosions.size() >= this.premiumLimit) {
            return;
        }
        String baseId = "explosion_";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.explosions.containsKey(id)) continue;
            FireworkExplosionFeatures eF = new FireworkExplosionFeatures((FeatureParentInterface)this, id);
            this.explosions.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, FireworkExplosionFeatures feature) {
        this.explosions.remove(feature.getId());
    }

    @Override
    public boolean isAvailable() {
        return !SCore.is1v12Less();
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return args.getMeta() instanceof FireworkMeta;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        ItemMeta itemMeta = args.getMeta();
        if (!this.explosions.isEmpty() && itemMeta instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)itemMeta;
            ArrayList<FireworkEffect> effects = new ArrayList<FireworkEffect>();
            for (FireworkExplosionFeatures explosion : this.explosions.values()) {
                FireworkEffect.Builder builder = FireworkEffect.builder();
                if (explosion.getHasTrail().getValue().booleanValue()) {
                    builder.withTrail();
                }
                if (explosion.getHasTwinkle().getValue().booleanValue()) {
                    builder.withFlicker();
                }
                if (!explosion.getFadeColors().getValues().isEmpty()) {
                    builder.withFade((Iterable)explosion.getFadeColors().getValue());
                }
                if (((Optional)explosion.getType().getValue()).isPresent()) {
                    builder.with((FireworkEffect.Type)((Optional)explosion.getType().getValue()).get());
                }
                if (!explosion.getColors().getValues().isEmpty()) {
                    builder.withColor(explosion.getColors().getValues());
                } else {
                    builder.withColor(Color.AQUA);
                }
                effects.add(builder.build());
            }
            if (!effects.isEmpty()) {
                fireworkMeta.addEffects(effects);
            }
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        if (meta instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)meta;
            int i = 0;
            for (FireworkEffect effect : fireworkMeta.getEffects()) {
                FireworkExplosionFeatures explosion = new FireworkExplosionFeatures((FeatureParentInterface)this, "explosion_" + i);
                explosion.getType().setValue(Optional.of(effect.getType()));
                explosion.getColors().setValues(effect.getColors());
                explosion.getFadeColors().setValues(effect.getFadeColors());
                explosion.getHasTrail().setValue(effect.hasTrail());
                explosion.getHasTwinkle().setValue(effect.hasFlicker());
                this.explosions.put(explosion.getId(), explosion);
                ++i;
            }
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.FIREWORK;
    }

    @Generated
    public Map<String, FireworkExplosionFeatures> getExplosions() {
        return this.explosions;
    }

    @Generated
    public boolean isNotSaveIfNoValue() {
        return this.notSaveIfNoValue;
    }

    @Generated
    public int getPremiumLimit() {
        return this.premiumLimit;
    }

    @Generated
    public void setExplosions(Map<String, FireworkExplosionFeatures> explosions) {
        this.explosions = explosions;
    }

    @Generated
    public void setNotSaveIfNoValue(boolean notSaveIfNoValue) {
        this.notSaveIfNoValue = notSaveIfNoValue;
    }

    @Generated
    public void setPremiumLimit(int premiumLimit) {
        this.premiumLimit = premiumLimit;
    }
}

