/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.itemcheckers;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.itemcheckers.ItemCheckerEnum;
import com.ssomar.score.features.custom.itemcheckers.ItemCheckerType;
import com.ssomar.score.features.editor.GenericFeatureParentEditorReloaded;
import com.ssomar.score.features.editor.GenericFeatureParentEditorReloadedManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.enums.EnumFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemCheckers
extends FeatureWithHisOwnEditor<ItemCheckers, ItemCheckers, GenericFeatureParentEditorReloaded, GenericFeatureParentEditorReloadedManager> {
    private EnumFeature<ItemCheckerType> itemCheckerType;
    private Map<ItemCheckerEnum, BooleanFeature> checkers;
    private Map<ItemCheckerEnum, Boolean> defaultValues;
    private ItemCheckerType defaultTypeValue;
    private List<ItemCheckerEnum> notFor1_11_less;
    private List<ItemCheckerEnum> notFor1_13_less;
    private List<ItemCheckerEnum> notFor1_18_less;
    private List<ItemCheckerEnum> notFor1_19_less;

    public ItemCheckers(FeatureParentInterface parent, ItemCheckerType defaultTypeValue, Map<ItemCheckerEnum, Boolean> defaultValues, FeatureSettingsInterface settings) {
        super(parent, settings);
        this.defaultValues = defaultValues;
        this.defaultTypeValue = defaultTypeValue;
        this.notFor1_11_less = new ArrayList<ItemCheckerEnum>();
        this.notFor1_13_less = new ArrayList<ItemCheckerEnum>();
        this.notFor1_18_less = new ArrayList<ItemCheckerEnum>();
        this.notFor1_19_less = new ArrayList<ItemCheckerEnum>();
        this.reset();
    }

    public static Map<ItemCheckerEnum, Boolean> getDefaultValuesOnFalse() {
        LinkedHashMap<ItemCheckerEnum, Boolean> defaultValues = new LinkedHashMap<ItemCheckerEnum, Boolean>();
        for (ItemCheckerEnum restriction : ItemCheckerEnum.values()) {
            defaultValues.put(restriction, false);
        }
        return defaultValues;
    }

    @Override
    public void reset() {
        this.itemCheckerType = new EnumFeature<ItemCheckerType>(this, Optional.of(this.defaultTypeValue), FeatureSettingsSCore.itemCheckerType, ItemCheckerType.class, ItemCheckerType.CUSTOM_CHECKS, "ItemCheckerType", Arrays.asList(ItemCheckerType.values()));
        this.checkers = new LinkedHashMap<ItemCheckerEnum, BooleanFeature>();
        for (ItemCheckerEnum restriction : ItemCheckerEnum.values()) {
            if (SCore.is1v11Less() && this.notFor1_11_less.contains((Object)restriction) || SCore.is1v13Less() && this.notFor1_13_less.contains((Object)restriction) || !SCore.is1v19Plus() && this.notFor1_18_less.contains((Object)restriction) || !SCore.is1v20Plus() && this.notFor1_19_less.contains((Object)restriction)) continue;
            this.checkers.put(restriction, new BooleanFeature(this, this.defaultValues.get((Object)restriction), restriction.featureSetting));
        }
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            error.addAll(this.itemCheckerType.load(plugin, section, isPremiumLoading));
            for (ItemCheckerEnum restriction : this.checkers.keySet()) {
                this.checkers.get((Object)restriction).load(plugin, section, isPremiumLoading);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.itemCheckerType.save(section);
        for (ItemCheckerEnum restriction : this.checkers.keySet()) {
            this.checkers.get((Object)restriction).save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public ItemCheckers getValue() {
        return this;
    }

    public boolean is(ItemCheckerEnum ask) {
        for (ItemCheckerEnum restriction : this.checkers.keySet()) {
            if (!restriction.equals((Object)ask)) continue;
            return this.checkers.get((Object)restriction).getValue();
        }
        return false;
    }

    public BooleanFeature get(ItemCheckerEnum ask) {
        for (ItemCheckerEnum restriction : this.checkers.keySet()) {
            if (!restriction.equals((Object)ask)) continue;
            return this.checkers.get((Object)restriction);
        }
        return null;
    }

    public int getRestrictionCount() {
        int count = 0;
        for (ItemCheckerEnum restriction : this.checkers.keySet()) {
            if (!this.checkers.get((Object)restriction).getValue().booleanValue()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public ItemCheckers initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = ((Optional)this.itemCheckerType.getValue()).get() == ItemCheckerType.ITEM_MUST_BE_EXACTLY_THE_SAME ? "&7Currently: &eThe items must be exactly the same" : "&7Currently: &eItem checkers activated: &e" + this.getRestrictionCount();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ItemCheckers clone(FeatureParentInterface newParent) {
        ItemCheckers restrictions = new ItemCheckers(this.getParent(), this.getDefaultTypeValue(), this.getDefaultValues(), this.getFeatureSettings());
        restrictions.setItemCheckerType(this.itemCheckerType.clone(restrictions));
        LinkedHashMap<ItemCheckerEnum, BooleanFeature> clone = new LinkedHashMap<ItemCheckerEnum, BooleanFeature>();
        for (ItemCheckerEnum restriction : this.checkers.keySet()) {
            clone.put(restriction, this.checkers.get((Object)restriction).clone(restrictions));
        }
        restrictions.setCheckers(clone);
        return restrictions;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.itemCheckerType);
        if (((Optional)this.itemCheckerType.getValue()).get() == ItemCheckerType.ITEM_MUST_BE_EXACTLY_THE_SAME) {
            return features;
        }
        for (ItemCheckerEnum checker : this.checkers.keySet()) {
            features.add(this.checkers.get((Object)checker));
        }
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof ItemCheckers) || !feature.getFeatureSettings().getIdentifier().equalsIgnoreCase(this.getFeatureSettings().getIdentifier())) continue;
            ItemCheckers restrictions = (ItemCheckers)feature;
            restrictions.setItemCheckerType(this.itemCheckerType);
            LinkedHashMap<ItemCheckerEnum, BooleanFeature> reload = new LinkedHashMap<ItemCheckerEnum, BooleanFeature>();
            for (ItemCheckerEnum restriction : this.checkers.keySet()) {
                reload.put(restriction, this.checkers.get((Object)restriction));
            }
            restrictions.setCheckers(reload);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorReloadedManager.getInstance().startEditing(player, this);
    }

    public boolean isSimilar(ItemStack item1, ItemStack item2) {
        if (item1 == null || item2 == null) {
            return item1 == item2;
        }
        if (((Optional)this.itemCheckerType.getValue()).get() == ItemCheckerType.ITEM_MUST_BE_EXACTLY_THE_SAME) {
            return item1.isSimilar(item2);
        }
        for (ItemCheckerEnum checker : this.checkers.keySet()) {
            if (!this.checkers.get((Object)checker).getValue().booleanValue() || checker.check(item1, item2)) continue;
            return false;
        }
        return true;
    }

    @Generated
    public EnumFeature<ItemCheckerType> getItemCheckerType() {
        return this.itemCheckerType;
    }

    @Generated
    public Map<ItemCheckerEnum, BooleanFeature> getCheckers() {
        return this.checkers;
    }

    @Generated
    public Map<ItemCheckerEnum, Boolean> getDefaultValues() {
        return this.defaultValues;
    }

    @Generated
    public ItemCheckerType getDefaultTypeValue() {
        return this.defaultTypeValue;
    }

    @Generated
    public List<ItemCheckerEnum> getNotFor1_11_less() {
        return this.notFor1_11_less;
    }

    @Generated
    public List<ItemCheckerEnum> getNotFor1_13_less() {
        return this.notFor1_13_less;
    }

    @Generated
    public List<ItemCheckerEnum> getNotFor1_18_less() {
        return this.notFor1_18_less;
    }

    @Generated
    public List<ItemCheckerEnum> getNotFor1_19_less() {
        return this.notFor1_19_less;
    }

    @Generated
    public void setItemCheckerType(EnumFeature<ItemCheckerType> itemCheckerType) {
        this.itemCheckerType = itemCheckerType;
    }

    @Generated
    public void setCheckers(Map<ItemCheckerEnum, BooleanFeature> checkers) {
        this.checkers = checkers;
    }

    @Generated
    public void setDefaultValues(Map<ItemCheckerEnum, Boolean> defaultValues) {
        this.defaultValues = defaultValues;
    }

    @Generated
    public void setDefaultTypeValue(ItemCheckerType defaultTypeValue) {
        this.defaultTypeValue = defaultTypeValue;
    }

    @Generated
    public void setNotFor1_11_less(List<ItemCheckerEnum> notFor1_11_less) {
        this.notFor1_11_less = notFor1_11_less;
    }

    @Generated
    public void setNotFor1_13_less(List<ItemCheckerEnum> notFor1_13_less) {
        this.notFor1_13_less = notFor1_13_less;
    }

    @Generated
    public void setNotFor1_18_less(List<ItemCheckerEnum> notFor1_18_less) {
        this.notFor1_18_less = notFor1_18_less;
    }

    @Generated
    public void setNotFor1_19_less(List<ItemCheckerEnum> notFor1_19_less) {
        this.notFor1_19_less = notFor1_19_less;
    }
}

