/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.itemglow;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Furnace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ItemGlowFeatures
extends FeatureWithHisOwnEditor<ItemGlowFeatures, ItemGlowFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private BooleanFeature glow;
    private BooleanFeature disableEnchantGlide;

    public ItemGlowFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.glow);
        this.reset();
    }

    @Override
    public void reset() {
        this.glow = new BooleanFeature(this, false, FeatureSettingsSCore.glow);
        this.disableEnchantGlide = new BooleanFeature(this, false, FeatureSettingsSCore.disableEnchantGlide);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        for (FeatureInterface feature : this.getFeatures()) {
            error.addAll(feature.load(plugin, config, isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(config);
        }
    }

    @Override
    public ItemGlowFeatures getValue() {
        return this;
    }

    @Override
    public ItemGlowFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = this.glow.getValue() != false ? "&7&oGlow: &a&l\u2714" : "&7&oEnabled: &c&l\u2718";
        finalDescription[finalDescription.length - 1] = this.disableEnchantGlide.getValue() != false ? "&7&oDisable Enchant Glide: &a&l\u2714" : "&7&oDisable Enchant Glide: &c&l\u2718";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ItemGlowFeatures clone(FeatureParentInterface newParent) {
        ItemGlowFeatures eF = new ItemGlowFeatures(newParent);
        eF.glow = this.glow.clone(eF);
        if (SCore.is1v20v5Plus()) {
            eF.disableEnchantGlide = this.disableEnchantGlide.clone(eF);
        }
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.glow);
        if (SCore.is1v20v5Plus()) {
            features.add(this.disableEnchantGlide);
        }
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        return section;
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof ItemGlowFeatures)) continue;
            ItemGlowFeatures eF = (ItemGlowFeatures)feature;
            eF.setGlow(this.glow);
            eF.setDisableEnchantGlide(this.disableEnchantGlide);
            break;
        }
    }

    public boolean canBeApplied(BlockData blockData) {
        return (SCore.isPaperOrFork() || SCore.is1v17Plus()) && blockData instanceof Furnace;
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public BooleanFeature getGlow() {
        return this.glow;
    }

    @Generated
    public BooleanFeature getDisableEnchantGlide() {
        return this.disableEnchantGlide;
    }

    @Generated
    public void setGlow(BooleanFeature glow) {
        this.glow = glow;
    }

    @Generated
    public void setDisableEnchantGlide(BooleanFeature disableEnchantGlide) {
        this.disableEnchantGlide = disableEnchantGlide;
    }
}

