/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.mf;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.MyFurnitureFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.strings.StringConverter;
import com.ssomar.score.utils.writer.NameSpaceKeyWriterReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MyFurnitureFeatures
extends FeatureWithHisOwnEditor<MyFurnitureFeatures, MyFurnitureFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItem {
    private BooleanFeature enable;
    private MyFurnitureFeature myFurnitureID;

    public MyFurnitureFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.myFurnitureFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.enable = new BooleanFeature(this, false, FeatureSettingsSCore.enable);
        this.myFurnitureID = new MyFurnitureFeature(this, FeatureSettingsSCore.myfurnitureID);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            error.addAll(this.enable.load(plugin, section, isPremiumLoading));
            error.addAll(this.myFurnitureID.load(plugin, section, isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.enable.save(section);
        this.myFurnitureID.save(section);
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public MyFurnitureFeatures getValue() {
        return this;
    }

    @Override
    public MyFurnitureFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = this.isRequirePremium() && !this.isPremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = this.enable.getValue() != false ? "&7Enabled: &a&l\u2714" : "&7Enabled: &c&l\u2718";
        finalDescription[finalDescription.length - 1] = "&7MyFurniture: &e" + this.myFurnitureID.getValueID().orElse("&cNONE");
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public MyFurnitureFeatures clone(FeatureParentInterface newParent) {
        MyFurnitureFeatures dropFeatures = new MyFurnitureFeatures(newParent);
        dropFeatures.setEnable(this.enable.clone(dropFeatures));
        dropFeatures.setMyFurnitureID(this.myFurnitureID.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.enable);
        features.add(this.myFurnitureID);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof MyFurnitureFeatures)) continue;
            MyFurnitureFeatures dropFeatures = (MyFurnitureFeatures)feature;
            dropFeatures.setEnable(this.enable);
            dropFeatures.setMyFurnitureID(this.myFurnitureID);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    public String getSimpleLocString(Location loc) {
        return loc.getWorld().getName() + "-" + loc.getBlockX() + "-" + loc.getBlockY() + "-" + loc.getBlockZ();
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v21v2Plus() && Dependency.MY_FURNITURE.isInstalled();
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return true;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        if (!(this.enable.getValue().booleanValue() && ((Optional)this.myFurnitureID.getValue()).isPresent() && Dependency.MY_FURNITURE.isEnabled())) {
            return;
        }
        PersistentDataContainer persistentDataContainer = args.getMeta().getPersistentDataContainer();
        NameSpaceKeyWriterReader.writeString((Plugin)MyFurniture.plugin, persistentDataContainer, "MF-ID", this.myFurnitureID.getValueID().get());
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        PersistentDataContainer persistentDataContainer;
        Optional<String> mfID;
        if (this.isAvailable() && this.isApplicable(args) && Dependency.MY_FURNITURE.isEnabled() && (mfID = NameSpaceKeyWriterReader.readString((Plugin)MyFurniture.plugin, persistentDataContainer = args.getMeta().getPersistentDataContainer(), "MF-ID")).isPresent()) {
            this.myFurnitureID.setValue(mfID);
            this.enable.setValue(true);
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.MYFURNITURE;
    }

    @Generated
    public BooleanFeature getEnable() {
        return this.enable;
    }

    @Generated
    public MyFurnitureFeature getMyFurnitureID() {
        return this.myFurnitureID;
    }

    @Generated
    public void setEnable(BooleanFeature enable) {
        this.enable = enable;
    }

    @Generated
    public void setMyFurnitureID(MyFurnitureFeature myFurnitureID) {
        this.myFurnitureID = myFurnitureID;
    }
}

