/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.nbttags;

import com.ssomar.score.features.custom.nbttags.NBTTag;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class BooleanNBTTag
extends NBTTag {
    private boolean valueBoolean;
    private boolean isValueBoolean;

    public BooleanNBTTag(ConfigurationSection configurationSection) {
        super(configurationSection);
    }

    public BooleanNBTTag(String key, boolean valueBoolean) {
        super(key);
        this.valueBoolean = valueBoolean;
        this.isValueBoolean = true;
    }

    @Override
    public boolean applyTo(ReadWriteNBT nbtItem, boolean onlyIfDifferent) {
        if (!onlyIfDifferent || nbtItem.getBoolean(this.getKey()).booleanValue() != this.isValueBoolean()) {
            nbtItem.setBoolean(this.getKey(), Boolean.valueOf(this.isValueBoolean()));
            return true;
        }
        return false;
    }

    @Override
    public boolean applyTo(NBTCompound nbtCompound, boolean onlyIfDifferent) {
        if (!onlyIfDifferent || nbtCompound.getBoolean(this.getKey()).booleanValue() != this.isValueBoolean()) {
            nbtCompound.setBoolean(this.getKey(), Boolean.valueOf(this.isValueBoolean));
            return true;
        }
        return false;
    }

    @Override
    public void saveValueInConfig(ConfigurationSection configurationSection, Integer index) {
        configurationSection.set("nbt." + index + ".type", (Object)"BOOLEAN");
        configurationSection.set("nbt." + index + ".value", (Object)this.isValueBoolean());
    }

    @Override
    public void loadValueFromConfig(ConfigurationSection configurationSection) {
        this.valueBoolean = configurationSection.getBoolean("value", true);
    }

    public String toString() {
        return "BOOLEAN::" + this.getKey() + "::" + this.isValueBoolean();
    }

    @Generated
    public boolean isValueBoolean() {
        return this.valueBoolean;
    }
}

