/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.nbttags;

import com.ssomar.score.features.custom.nbttags.NBTTag;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTList;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import de.tr7zw.nbtapi.iface.ReadWriteNBTList;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class ListStringNBTTag
extends NBTTag {
    private List<String> value;

    public ListStringNBTTag(ConfigurationSection configurationSection) {
        super(configurationSection);
    }

    public ListStringNBTTag(String key, List<String> value) {
        super(key);
        this.value = value;
    }

    @Override
    public boolean applyTo(ReadWriteNBT nbtItem, boolean onlyIfDifferent) {
        ReadWriteNBTList list = nbtItem.getStringList(this.getKey());
        boolean different = false;
        for (String s : this.value) {
            if (onlyIfDifferent && list.contains((Object)s)) continue;
            list.add((Object)s);
            different = true;
        }
        return different;
    }

    @Override
    public boolean applyTo(NBTCompound nbtCompound, boolean onlyIfDifferent) {
        NBTList list = nbtCompound.getStringList(this.getKey());
        boolean different = false;
        for (String s : this.value) {
            if (onlyIfDifferent && list.contains((Object)s)) continue;
            list.add((Object)s);
            different = true;
        }
        return different;
    }

    @Override
    public void saveValueInConfig(ConfigurationSection configurationSection, Integer index) {
        configurationSection.set("nbt." + index + ".type", (Object)"STRING_LIST");
        configurationSection.set("nbt." + index + ".value", this.value);
    }

    @Override
    public void loadValueFromConfig(ConfigurationSection configurationSection) {
        this.value = configurationSection.getStringList("value");
    }

    @Generated
    public List<String> getValue() {
        return this.value;
    }
}

