/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.potioneffects.group;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.potioneffects.group.PotionEffectGroupFeatureEditor;
import com.ssomar.score.features.custom.potioneffects.group.PotionEffectGroupFeatureEditorManager;
import com.ssomar.score.features.custom.potioneffects.potioneffect.PotionEffectFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PotionEffectGroupFeature
extends FeatureWithHisOwnEditor<PotionEffectGroupFeature, PotionEffectGroupFeature, PotionEffectGroupFeatureEditor, PotionEffectGroupFeatureEditorManager>
implements FeaturesGroup<PotionEffectFeature> {
    private Map<String, PotionEffectFeature> effects;
    private boolean notSaveIfNoValue;

    public PotionEffectGroupFeature(FeatureParentInterface parent, boolean notSaveIfNoValue) {
        super(parent, FeatureSettingsSCore.potionEffects);
        this.notSaveIfNoValue = notSaveIfNoValue;
        this.reset();
    }

    @Override
    public void reset() {
        this.effects = new HashMap<String, PotionEffectFeature>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                PotionEffectFeature attribute = new PotionEffectFeature((FeatureParentInterface)this, attributeID);
                List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.effects.put(attributeID, attribute);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfNoValue && this.effects.size() == 0) {
            return;
        }
        ConfigurationSection attributesSection = config.createSection(this.getName());
        for (String enchantmentID : this.effects.keySet()) {
            this.effects.get(enchantmentID).save(attributesSection);
        }
    }

    @Override
    public PotionEffectGroupFeature getValue() {
        return this;
    }

    @Override
    public PotionEffectGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oAttribute(s) added: &e" + this.effects.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public PotionEffectFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (PotionEffectFeature x : this.effects.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public PotionEffectGroupFeature clone(FeatureParentInterface newParent) {
        PotionEffectGroupFeature eF = new PotionEffectGroupFeature(newParent, this.isNotSaveIfNoValue());
        HashMap<String, PotionEffectFeature> newEffects = new HashMap<String, PotionEffectFeature>();
        for (String key : this.effects.keySet()) {
            newEffects.put(key, this.effects.get(key).clone(eF));
        }
        eF.setEffects(newEffects);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.effects.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof PotionEffectGroupFeature)) continue;
            PotionEffectGroupFeature eF = (PotionEffectGroupFeature)feature;
            eF.setEffects(this.getEffects());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        PotionEffectGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "pEffect";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.effects.containsKey(id)) continue;
            PotionEffectFeature eF = new PotionEffectFeature((FeatureParentInterface)this, id);
            this.effects.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, PotionEffectFeature feature) {
        this.effects.remove(feature.getId());
    }

    @Generated
    public Map<String, PotionEffectFeature> getEffects() {
        return this.effects;
    }

    @Generated
    public boolean isNotSaveIfNoValue() {
        return this.notSaveIfNoValue;
    }

    @Generated
    public void setEffects(Map<String, PotionEffectFeature> effects) {
        this.effects = effects;
    }

    @Generated
    public void setNotSaveIfNoValue(boolean notSaveIfNoValue) {
        this.notSaveIfNoValue = notSaveIfNoValue;
    }
}

