/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.variables.base.group;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.variables.base.group.VariablesGroupFeatureEditor;
import com.ssomar.score.features.custom.variables.base.group.VariablesGroupFeatureEditorManager;
import com.ssomar.score.features.custom.variables.base.variable.VariableFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class VariablesGroupFeature
extends FeatureWithHisOwnEditor<VariablesGroupFeature, VariablesGroupFeature, VariablesGroupFeatureEditor, VariablesGroupFeatureEditorManager>
implements FeaturesGroup<VariableFeature> {
    private Map<String, VariableFeature> variables;

    public VariablesGroupFeature(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.variables);
        this.reset();
    }

    public static VariablesGroupFeature buildNull() {
        return new VariablesGroupFeature(null);
    }

    @Override
    public void reset() {
        this.variables = new HashMap<String, VariableFeature>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                VariableFeature attribute = new VariableFeature((FeatureParentInterface)this, attributeID);
                List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.variables.put(attributeID, attribute);
            }
        }
        return error;
    }

    public List<String> getVariablesName() {
        ArrayList<String> variablesName = new ArrayList<String>();
        for (String variableName : this.variables.keySet()) {
            VariableFeature variable = this.variables.get(variableName);
            variablesName.add((String)((Optional)variable.getVariableName().getValue()).get());
        }
        return variablesName;
    }

    public VariableFeature getVariable(String variableName) {
        for (String var2 : this.variables.keySet()) {
            VariableFeature variable = this.variables.get(var2);
            if (!((String)((Optional)variable.getVariableName().getValue()).get()).equals(variableName)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection attributesSection = config.createSection(this.getName());
        for (String enchantmentID : this.variables.keySet()) {
            this.variables.get(enchantmentID).save(attributesSection);
        }
        if (this.isSavingOnlyIfDiffDefault() && attributesSection.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public VariablesGroupFeature getValue() {
        return this;
    }

    @Override
    public VariablesGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription;
        if (gui.getClass().getSimpleName().toString().equals("ExecutableBlockEditor")) {
            finalDescription = new String[this.getEditorDescription().length + 5];
            System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
            finalDescription[finalDescription.length - 5] = GUI.CLICK_HERE_TO_CHANGE;
            finalDescription[finalDescription.length - 4] = "&7&oVariable(s) added: &e" + this.variables.size();
            finalDescription[finalDescription.length - 3] = "&cFor IMPORT_FROM_EXECUTABLE_ITEMS:";
            finalDescription[finalDescription.length - 2] = "&cSource ExecutableItem must include";
            finalDescription[finalDescription.length - 1] = "&cthis block's variables.";
        } else {
            finalDescription = new String[this.getEditorDescription().length + 2];
            System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
            finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
            finalDescription[finalDescription.length - 1] = "&7&oVariable(s) added: &e" + this.variables.size();
        }
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public VariablesGroupFeature clone(FeatureParentInterface newParent) {
        VariablesGroupFeature eF = new VariablesGroupFeature(this.getParent());
        HashMap<String, VariableFeature> newVariables = new HashMap<String, VariableFeature>();
        for (String variableName : this.variables.keySet()) {
            VariableFeature variable = this.variables.get(variableName);
            newVariables.put(variableName, variable.clone(eF));
        }
        eF.setVariables(newVariables);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.variables.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof VariablesGroupFeature)) continue;
            VariablesGroupFeature eF = (VariablesGroupFeature)feature;
            eF.setVariables(this.getVariables());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        VariablesGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public VariableFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (VariableFeature x : this.variables.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "var";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.variables.containsKey(id)) continue;
            VariableFeature eF = new VariableFeature((FeatureParentInterface)this, id);
            eF.getIsRefreshableClean().setValue(true);
            this.variables.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, VariableFeature feature) {
        this.variables.remove(feature.getId());
    }

    @Generated
    public Map<String, VariableFeature> getVariables() {
        return this.variables;
    }

    @Generated
    public void setVariables(Map<String, VariableFeature> variables) {
        this.variables = variables;
    }
}

