/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.CustomColor;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BukkitColorFeature
extends FeatureAbstract<Optional<Color>, BukkitColorFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<Color> value;
    private Optional<Color> defaultValue;

    public BukkitColorFeature(FeatureParentInterface parent, Optional<Color> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.of(CustomColor.getNullColor());
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        if (!colorStr.equals("NULL") && !colorStr.equals("NO_COLOR")) {
            try {
                Color chatColor = CustomColor.valueOf(colorStr);
                this.value = Optional.ofNullable(chatColor);
                FeatureReturnCheckPremium<Color> checkPremium = this.checkPremium("Color", chatColor, this.defaultValue, isPremiumLoading);
                if (checkPremium.isHasError()) {
                    this.value = Optional.of(checkPremium.getNewValue());
                }
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load the Color value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> ChatColors available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Color.html");
                this.value = Optional.of(CustomColor.getNullColor());
            }
        } else {
            this.value = Optional.of(CustomColor.getNullColor());
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(chatColor -> config.set(this.getName(), (Object)CustomColor.getName(chatColor)));
    }

    @Override
    public Optional<Color> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public BukkitColorFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 1];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 1] = !this.isPremium() && this.isRequirePremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        Color finalValue = ((Optional)value).orElse(CustomColor.getNullColor());
        this.updateColor(finalValue, gui);
    }

    @Override
    public BukkitColorFeature clone(FeatureParentInterface newParent) {
        BukkitColorFeature clone = new BukkitColorFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        if (!this.isPremium() && this.isRequirePremium()) {
            return true;
        }
        this.updateColor(this.nextColor(this.getColor((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        if (!this.isPremium() && this.isRequirePremium()) {
            return true;
        }
        this.updateColor(this.prevColor(this.getColor((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public Color nextColor(Color particle) {
        boolean next = false;
        for (Color check : CustomColor.values()) {
            if (check.equals((Object)particle)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return CustomColor.values()[0];
    }

    public Color prevColor(Color color) {
        int i = -1;
        int cpt = 0;
        for (Color check : CustomColor.values()) {
            if (check.equals((Object)color)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return CustomColor.values()[CustomColor.values().length - 1];
        }
        return CustomColor.values()[cpt - 1];
    }

    public void updateColor(Color color, GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        this.value = Optional.of(color);
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, 2);
        boolean find = false;
        for (Color check : CustomColor.values()) {
            if (color.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + CustomColor.getName(color), true));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + CustomColor.getName(check), true));
        }
        for (Color check : CustomColor.values()) {
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + CustomColor.getName(check), true));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public Color getColor(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return CustomColor.valueOf(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    @Generated
    public Optional<Color> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<Color> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<Color> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

