/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.CustomFurniture;
import dev.lone.itemsadder.api.CustomStack;
import dev.lone.itemsadder.api.ItemsAdder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemsAdderFeature
extends FeatureAbstract<Optional<String>, ItemsAdderFeature>
implements FeatureRequireOnlyClicksInEditor {
    private static final boolean DEBUG = false;
    private Optional<String> value = Optional.empty();

    public ItemsAdderFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "");
        this.value = colorStr.isEmpty() ? Optional.empty() : Optional.of(colorStr);
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        this.value.ifPresent(s -> config.set(this.getName(), s));
    }

    @Override
    public Optional<String> getValue() {
        if (this.value.isPresent() && SCore.hasItemsAdder && CustomStack.getInstance((String)this.value.get()) != null) {
            return this.value;
        }
        return Optional.empty();
    }

    public Optional<ItemStack> getItemStack() {
        if (((Optional)this.getValue()).isPresent()) {
            return Optional.of(CustomStack.getInstance((String)((String)((Optional)this.getValue()).get())).getItemStack());
        }
        return Optional.empty();
    }

    public Object placeItemAdder(Location location, final ItemStack itemStack) {
        if (((Optional)this.getValue()).isPresent()) {
            String id = (String)((Optional)this.getValue()).get();
            try {
                CustomBlock customBlock = CustomBlock.getInstance((String)id);
                if (customBlock != null) {
                    SsomarDev.testMsg("placeItemsAdder Block: " + id, false);
                    customBlock.place(location);
                    return customBlock;
                }
            }
            catch (Error | Exception e) {
                try {
                    SsomarDev.testMsg("placeItemsAdder is Furniture " + id, false);
                    CustomFurniture customFurniture = CustomFurniture.spawnPreciseNonSolid((String)id, (Location)location);
                    ArmorStand armorStand = (ArmorStand)customFurniture.getArmorstand();
                    final EntityEquipment entityEquip = armorStand.getEquipment();
                    Runnable runnable3 = new Runnable(){

                        @Override
                        public void run() {
                            entityEquip.setItem(EquipmentSlot.HEAD, itemStack);
                        }
                    };
                    SCore.schedulerHook.runEntityTask(runnable3, null, (Entity)armorStand, 10L);
                    return customFurniture;
                }
                catch (Exception e1) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public ItemsAdderFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = "&8>> &6SHIFT : &eBOOST SCROLL";
        finalDescription[finalDescription.length - 1] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        ItemStack item = new ItemStack(this.getEditorMaterial());
        if (((Optional)this.getValue()).isPresent()) {
            item = this.getItemStack().get();
        }
        gui.createItem(item, 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        if (SCore.hasItemsAdder) {
            if (((Optional)this.getValue()).isPresent()) {
                this.updateItemAdder(this.value.get(), gui);
            } else {
                this.updateItemAdder(((CustomStack)ItemsAdder.getAllItems().get(0)).getId(), gui);
            }
        } else {
            this.updateItemAdder(null, gui);
        }
    }

    @Override
    public ItemsAdderFeature clone(FeatureParentInterface newParent) {
        ItemsAdderFeature clone = new ItemsAdderFeature(newParent, this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = Optional.empty();
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        if (SCore.hasItemsAdder) {
            String id = this.getItemAdder((GUI)manager.getCache().get(editor)).get();
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            id = this.nextItemAdder(id);
            this.updateItemAdder(id, (GUI)manager.getCache().get(editor));
        }
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        if (SCore.hasItemsAdder) {
            String id = this.getItemAdder((GUI)manager.getCache().get(editor)).get();
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            id = this.prevItemAdder(id);
            this.updateItemAdder(id, (GUI)manager.getCache().get(editor));
        }
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        if (SCore.hasItemsAdder) {
            this.updateItemAdder(this.nextItemAdder(this.getItemAdder((GUI)manager.getCache().get(editor)).get()), (GUI)manager.getCache().get(editor));
        }
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        if (SCore.hasItemsAdder) {
            this.updateItemAdder(this.prevItemAdder(this.getItemAdder((GUI)manager.getCache().get(editor)).get()), (GUI)manager.getCache().get(editor));
        }
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public String nextItemAdder(String id) {
        boolean next = false;
        for (String check : this.getSortItemsAdder()) {
            if (check.equals(id)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortItemsAdder().get(0);
    }

    public String prevItemAdder(String id) {
        int i = -1;
        int cpt = 0;
        for (String check : this.getSortItemsAdder()) {
            if (check.equals(id)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortItemsAdder().get(this.getSortItemsAdder().size() - 1);
        }
        return this.getSortItemsAdder().get(cpt - 1);
    }

    public void updateItemAdder(String id, GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        int slot = gui.getInv().first(item);
        this.initItemParentEditor(gui, slot);
        item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 3);
        if (id == null) {
            id = "NULLLLL";
        }
        this.value = Optional.of(id);
        if (SCore.hasItemsAdder) {
            boolean find = false;
            for (String check : this.getSortItemsAdder()) {
                if (id.equals(check)) {
                    lore.add(StringConverter.coloredString("&2\u27a4 &a" + id));
                    find = true;
                    continue;
                }
                if (!find) continue;
                if (lore.size() == 17) break;
                lore.add(StringConverter.coloredString("&6\u2726 &e" + check));
            }
            for (String check : this.getSortItemsAdder()) {
                if (lore.size() != 17) {
                    lore.add(StringConverter.coloredString("&6\u2726 &e" + check));
                    continue;
                }
                break;
            }
        } else {
            lore.add(StringConverter.coloredString("&4\u27a4 &cYou must have &6ItemsAdder"));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public Optional<String> getItemAdder(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            if (str.contains("You must have &6ItemsAdder")) {
                return Optional.empty();
            }
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return Optional.ofNullable(str.split("\u27a4 ")[1]);
        }
        return Optional.empty();
    }

    public List<String> getSortItemsAdder() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (SCore.hasItemsAdder) {
            for (CustomStack c : ItemsAdder.getAllItems()) {
                map.put(c.getId(), c.getId());
            }
        }
        return new ArrayList<String>(map.values());
    }

    @Generated
    public void setValue(Optional<String> value) {
        this.value = value;
    }
}

