/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class ListUncoloredStringFeature
extends ListFeatureAbstract<String, ListUncoloredStringFeature> {
    private Optional<List<Suggestion>> suggestions;

    public ListUncoloredStringFeature(FeatureParentInterface parent, List<String> defaultValue, FeatureSettingsInterface featureSettings, Optional<List<Suggestion>> suggestions) {
        super(parent, "List of Colored Strings", defaultValue, featureSettings);
        this.suggestions = suggestions;
        this.reset();
    }

    @Override
    public List<String> loadValues(List<String> entries, List<String> errors) {
        ArrayList<String> uncolored = new ArrayList<String>();
        for (String s : entries) {
            uncolored.add(StringConverter.decoloredString(s));
        }
        return uncolored;
    }

    @Override
    public String transfromToString(String value) {
        return value;
    }

    @Override
    public ListUncoloredStringFeature clone(FeatureParentInterface newParent) {
        ListUncoloredStringFeature clone = new ListUncoloredStringFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.suggestions);
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        return Optional.empty();
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        return this.suggestions.orElseGet(ArrayList::new);
    }

    @Override
    public String getTips() {
        return "";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, false, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }

    public List<String> getValue(StringPlaceholder sp) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.getValues()) {
            result.add(sp.replacePlaceholder(s));
        }
        return result;
    }

    @Generated
    public void setSuggestions(Optional<List<Suggestion>> suggestions) {
        this.suggestions = suggestions;
    }
}

