/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.scheduler;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.scheduler.ScheduleFeatures;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomTriggerScheduler {
    private static CustomTriggerScheduler instance;
    private Map<String, Runnable> tasksToRun;
    private Map<String, ScheduleFeatures> features;
    private Map<String, List<ScheduledTask>> tasks;
    private long lastCalculationTime = System.currentTimeMillis();

    private CustomTriggerScheduler() {
        this.tasksToRun = new HashMap<String, Runnable>();
        this.features = new HashMap<String, ScheduleFeatures>();
        this.tasks = new HashMap<String, List<ScheduledTask>>();
        SCore.schedulerHook.runAsyncRepeatingTask(this::runCalculations, 45L, 2400L);
    }

    public static CustomTriggerScheduler getInstance() {
        if (instance == null) {
            instance = new CustomTriggerScheduler();
        }
        return instance;
    }

    public void addCustomTriggerScheduler(String id, Runnable task, ScheduleFeatures features) {
        this.tasks.put(id, new ArrayList());
        this.tasksToRun.put(id, task);
        this.features.put(id, features);
        this.runCalculation(id);
    }

    public void runCalculations() {
        this.lastCalculationTime = System.currentTimeMillis();
        for (String id : this.tasksToRun.keySet()) {
            SsomarDev.testMsg("Running calculation for: " + id, true);
            this.runCalculation(id);
        }
    }

    public void runCalculation(String id) {
        if (this.tasksToRun.containsKey(id)) {
            List<ScheduledTask> tasks = this.tasks.get(id);
            for (ScheduledTask task1 : tasks) {
                task1.cancel();
            }
            tasks.clear();
        }
        long time = 120L - (System.currentTimeMillis() - this.lastCalculationTime);
        List<Long> timestamps = this.features.get(id).getNextTimestamp(time * 1000L);
        for (Long timestamp : timestamps) {
            long delayInTicks = (timestamp - System.currentTimeMillis()) / 50L;
            SsomarDev.testMsg("Running task for " + id + " in " + delayInTicks + " ticks", true);
            ScheduledTask task = SCore.schedulerHook.runAsyncTask(this.tasksToRun.get(id), delayInTicks);
            this.tasks.computeIfAbsent(id, k -> new ArrayList()).add(task);
        }
    }
}

