/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils;

import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.usedapi.MythicMobsAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class EntityBuilder {
    private String entityDefinitionToBuild;

    public EntityBuilder(String entityDefinitionToBuild) {
        this.entityDefinitionToBuild = entityDefinitionToBuild;
    }

    public Entity buildEntity(Location location) {
        Entity entity = null;
        String entityName = this.entityDefinitionToBuild;
        if (Dependency.MYTHIC_MOBS.isEnabled()) {
            entity = MythicMobsAPI.buildMythicMob(entityName, location);
        }
        if (entity != null) {
            return entity;
        }
        try {
            EntityType entityType = EntityType.valueOf((String)entityName.toUpperCase());
            entity = location.getWorld().spawnEntity(location, entityType);
        }
        catch (Exception ignored) {
            try {
                entity = Bukkit.getEntityFactory().createEntitySnapshot(entityName).createEntity(location);
            }
            catch (Exception ignored2) {
                entity = location.getWorld().spawnEntity(location, EntityType.PIG);
            }
        }
        return entity;
    }

    public EntityType getEntityType() {
        EntityType entityType = null;
        try {
            entityType = EntityType.valueOf((String)this.entityDefinitionToBuild.toUpperCase());
        }
        catch (Exception ignored) {
            try {
                entityType = Bukkit.getEntityFactory().createEntitySnapshot(this.entityDefinitionToBuild).getEntityType();
            }
            catch (Exception ignored2) {
                entityType = EntityType.PIG;
            }
        }
        return entityType;
    }
}

