/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.variables;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.MaterialFeature;
import com.ssomar.score.features.types.VariableForFeature;
import com.ssomar.score.features.types.VariableTypeFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.projectiles.SProjectileEditor;
import com.ssomar.score.projectiles.SProjectileEditorManager;
import com.ssomar.score.sobject.SObjectWithFileEditable;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.VariableType;
import com.ssomar.score.variables.VariableEditorManager;
import com.ssomar.score.variables.VariableForEnum;
import com.ssomar.score.variables.VariablesEditor;
import com.ssomar.score.variables.loader.VariablesLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Variable
extends SObjectWithFileEditable<Variable, SProjectileEditor, SProjectileEditorManager> {
    private VariableTypeFeature type;
    private VariableForFeature forFeature;
    private Map<String, List<String>> values;
    private ColoredStringFeature defaultValue;
    private MaterialFeature icon;

    public Variable(FeatureParentInterface parent, String id, String path) {
        super(SCore.plugin, id, parent, FeatureSettingsSCore.VARIABLE, path, VariablesLoader.getInstance());
        this.reset();
    }

    public Variable(String id, String path) {
        super(SCore.plugin, id, FeatureSettingsSCore.VARIABLE, path, VariablesLoader.getInstance());
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        for (FeatureInterface featureInterface : this.getFeatures()) {
            errors.addAll(featureInterface.load(plugin, config, isPremiumLoading));
        }
        if (config.isConfigurationSection("values")) {
            for (String key : config.getConfigurationSection("values").getKeys(false)) {
                if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) {
                    this.values.put(key, config.getStringList("values." + key));
                    continue;
                }
                this.values.put(key, Arrays.asList(config.getString("values." + key)));
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        for (String s : config.getKeys(false)) {
            config.set(s, null);
        }
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(config);
        }
        config.set("values", null);
        for (String key : this.values.keySet()) {
            if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST) && !this.values.get(key).isEmpty()) {
                config.set("values." + key, this.values.get(key));
                continue;
            }
            if (this.values.get(key).isEmpty()) continue;
            config.set("values." + key, (Object)this.values.get(key).get(0));
        }
    }

    @Override
    public Variable getValue() {
        return this;
    }

    @Override
    public Variable initItemParentEditor(GUI gui, int slot) {
        return null;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public void reset() {
        this.defaultValue = new ColoredStringFeature(this, Optional.empty(), FeatureSettingsSCore.default_string);
        this.type = new VariableTypeFeature(this, Optional.of(VariableType.NUMBER), FeatureSettingsSCore.type, false);
        this.forFeature = new VariableForFeature(this, Optional.empty(), FeatureSettingsSCore.for_);
        this.values = new HashMap<String, List<String>>();
        this.icon = new MaterialFeature(this, Optional.of(Material.PAPER), FeatureSettingsSCore.icon);
    }

    @Override
    public Variable clone(FeatureParentInterface newParent) {
        Variable clone = new Variable(this, this.getId(), this.getPath());
        clone.setType(this.type.clone(clone));
        clone.setForFeature(this.forFeature.clone(clone));
        clone.setDefaultValue(this.defaultValue.clone(clone));
        clone.setValues(new HashMap<String, List<String>>(this.values));
        clone.setIcon(this.icon.clone(clone));
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.type);
        features.add(this.forFeature);
        features.add(this.defaultValue);
        features.add(this.icon);
        return features;
    }

    @Override
    public String getParentInfo() {
        return "Variable: " + this.getId();
    }

    @Override
    public void reload() {
        if (this.getParent() instanceof Variable) {
            Variable variable = (Variable)this.getParent();
            variable.setType(this.type);
            variable.setForFeature(this.forFeature);
            variable.setDefaultValue(this.defaultValue);
            variable.setIcon(this.icon);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        NewSObjectsManagerEditor.getInstance().startEditing(player, new VariablesEditor());
    }

    @Override
    public void openEditor(@NotNull Player player) {
        VariableEditorManager.getInstance().startEditing(player, this);
    }

    public String getValuesStr() {
        StringBuilder sb = new StringBuilder();
        if (((Optional)this.defaultValue.getValue()).isPresent()) {
            sb.append("&7Default value: &f\n");
            sb.append("&e").append((String)((Optional)this.defaultValue.getValue()).get()).append("\n");
        }
        sb.append("&7Values: &f\n");
        for (String key : this.values.keySet()) {
            if (!key.equals("global")) {
                try {
                    UUID uuid = UUID.fromString(key);
                    OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                    sb.append("&e").append(player.getName()).append("&7: &a").append(this.values.get(key)).append("\n");
                }
                catch (Exception exception) {}
                continue;
            }
            sb.append("&e").append(key).append("&7: &a").append(this.values.get(key)).append("\n");
        }
        return sb.toString();
    }

    public String getValue(Optional<OfflinePlayer> optPlayer, Optional<Integer> indexOpt) {
        List<String> globalValues;
        if (!((Optional)this.forFeature.getValue()).isPresent()) {
            return "Invalid variable configuration";
        }
        if (((VariableForEnum)((Object)((Optional)this.forFeature.getValue()).get())).equals((Object)VariableForEnum.PLAYER)) {
            List<String> playerValues;
            if (optPlayer.isPresent() && this.values.containsKey(optPlayer.get().getUniqueId() + "") && (playerValues = this.values.get(optPlayer.get().getUniqueId() + "")).size() > indexOpt.orElse(0)) {
                if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) {
                    if (indexOpt.isPresent()) {
                        return playerValues.get(indexOpt.get());
                    }
                    return playerValues.toString();
                }
                return playerValues.get(0);
            }
        } else if (this.values.containsKey("global") && (globalValues = this.values.get("global")).size() > indexOpt.orElse(0)) {
            if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) {
                if (indexOpt.isPresent()) {
                    return globalValues.get(indexOpt.get());
                }
                return globalValues.toString();
            }
            return globalValues.get(0);
        }
        if (((Optional)this.defaultValue.getValue()).isPresent()) {
            return (String)((Optional)this.defaultValue.getValue()).get();
        }
        return "";
    }

    public int sizeValue(Optional<OfflinePlayer> optPlayer, Optional<Integer> indexOpt) {
        List<String> globalValues;
        if (((VariableForEnum)((Object)((Optional)this.forFeature.getValue()).get())).equals((Object)VariableForEnum.PLAYER)) {
            List<String> playerValues;
            if (optPlayer.isPresent() && this.values.containsKey(optPlayer.get().getUniqueId() + "") && (playerValues = this.values.get(optPlayer.get().getUniqueId() + "")).size() > indexOpt.orElse(0)) {
                if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) {
                    if (indexOpt.isPresent()) {
                        return playerValues.get(indexOpt.get()).length();
                    }
                    return playerValues.size();
                }
                return playerValues.get(0).length();
            }
        } else if (this.values.containsKey("global") && (globalValues = this.values.get("global")).size() > indexOpt.orElse(0)) {
            if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) {
                if (indexOpt.isPresent()) {
                    return globalValues.get(indexOpt.get()).length();
                }
                return globalValues.size();
            }
            return globalValues.get(0).length();
        }
        return 0;
    }

    public boolean containsValue(Optional<OfflinePlayer> optPlayer, String value) {
        List<String> globalValues;
        if (((VariableForEnum)((Object)((Optional)this.forFeature.getValue()).get())).equals((Object)VariableForEnum.PLAYER)) {
            List<String> playerValues;
            if (optPlayer.isPresent() && this.values.containsKey(optPlayer.get().getUniqueId() + "") && (playerValues = this.values.get(optPlayer.get().getUniqueId() + "")).size() > 0) {
                if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) {
                    return playerValues.contains(value);
                }
                return playerValues.get(0).contains(value);
            }
        } else if (this.values.containsKey("global") && (globalValues = this.values.get("global")).size() > 0) {
            if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) {
                return globalValues.contains(value);
            }
            return globalValues.get(0).contains(value);
        }
        return false;
    }

    public Optional<String> modifValue(Optional<OfflinePlayer> optPlayer, String value) {
        String actualValue = this.getValue(optPlayer, Optional.empty());
        if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.NUMBER)) {
            try {
                if (actualValue.isEmpty()) {
                    actualValue = "0";
                }
                double actual = Double.parseDouble(actualValue);
                double modif = Double.parseDouble(value);
                double result = actual + modif;
                actualValue = String.valueOf(result);
            }
            catch (NumberFormatException e) {
                return Optional.of("\u00a7cThe value is not a number");
            }
        } else {
            actualValue = actualValue + value;
        }
        Optional<String> setErr = this.setValue(optPlayer, actualValue);
        if (setErr.isPresent()) {
            return setErr;
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<String> setValue(Optional<OfflinePlayer> optPlayer, String value) {
        if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.NUMBER)) {
            try {
                Double.parseDouble(value);
            }
            catch (Exception e) {
                return Optional.of("\u00a7cThe value must be a number");
            }
        }
        if (((VariableForEnum)((Object)((Optional)this.forFeature.getValue()).get())).equals((Object)VariableForEnum.PLAYER)) {
            if (!optPlayer.isPresent()) return Optional.of("\u00a7cYou need to attribute the value of this variable to a player");
            this.values.put(optPlayer.get().getUniqueId() + "", Arrays.asList(value));
        } else {
            this.values.put("global", Arrays.asList(value));
        }
        this.save(false);
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<String> addValue(Optional<OfflinePlayer> optPlayer, String value, Optional<Integer> indexOpt) {
        if (!((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) return Optional.of("\u00a7cTo add something your variable must be a list");
        if (((VariableForEnum)((Object)((Optional)this.forFeature.getValue()).get())).equals((Object)VariableForEnum.PLAYER)) {
            if (!optPlayer.isPresent()) return Optional.of("\u00a7cYou need to attribute the value of this variable to a player");
            List<String> actualValues = this.values.get(optPlayer.get().getUniqueId() + "");
            if (actualValues == null) {
                actualValues = new ArrayList<String>();
            }
            actualValues.add(indexOpt.orElse(actualValues.size()), value);
            this.values.put(optPlayer.get().getUniqueId() + "", actualValues);
        } else {
            List<String> actualValues = this.values.get("global");
            if (actualValues == null) {
                actualValues = new ArrayList<String>();
            }
            actualValues.add(indexOpt.orElse(actualValues.size()), value);
            this.values.put("global", actualValues);
        }
        this.save(false);
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<String> removeValue(Optional<OfflinePlayer> optPlayer, Optional<Integer> indexOpt, Optional<String> valueOpt) {
        if (!((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) return Optional.of("\u00a7cTo remove something your variable must be a list");
        if (((VariableForEnum)((Object)((Optional)this.forFeature.getValue()).get())).equals((Object)VariableForEnum.PLAYER)) {
            if (!optPlayer.isPresent()) return Optional.of("\u00a7cYou need to attribute the remove of this variable to a player");
            List<String> actualValues = this.values.get(optPlayer.get().getUniqueId() + "");
            try {
                if (valueOpt.isPresent()) {
                    actualValues.remove(valueOpt.get());
                } else {
                    actualValues.remove(indexOpt.orElse(actualValues.size() - 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.values.put(optPlayer.get().getUniqueId() + "", actualValues);
        } else {
            List<String> actualValues = this.values.get("global");
            try {
                if (valueOpt.isPresent()) {
                    actualValues.remove(valueOpt.get());
                } else {
                    actualValues.remove(indexOpt.orElse(actualValues.size() - 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.values.put("global", actualValues);
        }
        this.save(false);
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<String> clearValue(Optional<OfflinePlayer> optPlayer) {
        if (((VariableForEnum)((Object)((Optional)this.forFeature.getValue()).get())).equals((Object)VariableForEnum.PLAYER)) {
            if (!optPlayer.isPresent()) return Optional.of("\u00a7cYou need to attribute the remove of this variable to a player");
            this.values.remove(optPlayer.get().getUniqueId() + "");
        } else {
            this.values.remove("global");
        }
        this.save(false);
        return Optional.empty();
    }

    public Optional<String> clearAllValues() {
        if (((VariableForEnum)((Object)((Optional)this.forFeature.getValue()).get())).equals((Object)VariableForEnum.PLAYER)) {
            this.values.clear();
        } else {
            this.values.remove("global");
        }
        this.save(false);
        return Optional.empty();
    }

    @Override
    public ItemStack getIconItem() {
        return new ItemStack((Material)((Optional)this.icon.getValue()).get());
    }

    public boolean equals(Variable obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Optional)this.type.getValue()).get() != ((Optional)obj.getType().getValue()).get()) {
            return false;
        }
        if (((Optional)this.forFeature.getValue()).get() != ((Optional)obj.getForFeature().getValue()).get()) {
            return false;
        }
        for (String key : this.values.keySet()) {
            if (!obj.getValues().containsKey(key)) {
                return false;
            }
            List<String> thisList = this.values.get(key);
            List<String> objList = obj.getValues().get(key);
            if (thisList.size() != objList.size()) {
                return false;
            }
            for (int i = 0; i < thisList.size(); ++i) {
                if (thisList.get(i).equals(objList.get(i))) continue;
                return false;
            }
        }
        if (!((Optional)this.defaultValue.getValue()).isPresent() && ((Optional)obj.getDefaultValue().getValue()).isPresent()) {
            return false;
        }
        if (((Optional)this.defaultValue.getValue()).isPresent() && !((Optional)obj.getDefaultValue().getValue()).isPresent()) {
            return false;
        }
        return !((Optional)this.defaultValue.getValue()).isPresent() || !((Optional)obj.getDefaultValue().getValue()).isPresent() || ((String)((Optional)this.defaultValue.getValue()).get()).equals(((Optional)obj.getDefaultValue().getValue()).get());
    }

    @Generated
    public VariableTypeFeature getType() {
        return this.type;
    }

    @Generated
    public VariableForFeature getForFeature() {
        return this.forFeature;
    }

    @Generated
    public Map<String, List<String>> getValues() {
        return this.values;
    }

    @Generated
    public ColoredStringFeature getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public MaterialFeature getIcon() {
        return this.icon;
    }

    @Generated
    public void setType(VariableTypeFeature type) {
        this.type = type;
    }

    @Generated
    public void setForFeature(VariableForFeature forFeature) {
        this.forFeature = forFeature;
    }

    @Generated
    public void setValues(Map<String, List<String>> values) {
        this.values = values;
    }

    @Generated
    public void setDefaultValue(ColoredStringFeature defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setIcon(MaterialFeature icon) {
        this.icon = icon;
    }
}

