/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.util.commands;

import com.ssomar.score.commands.runnable.SCommand;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.Nullable;

public class RandomRun
extends SCommand {
    public static final List<String> RANDOM_RUN_NAMES = Arrays.asList("RANDOM_RUN", "RANDOM RUN:");

    @Override
    public List<String> getNames() {
        return RANDOM_RUN_NAMES;
    }

    @Override
    public String getTemplate() {
        return "RANDOM_RUN selectionCount:{number}";
    }

    @Override
    public ChatColor getColor() {
        return ChatColor.YELLOW;
    }

    @Override
    public ChatColor getExtraColor() {
        return ChatColor.GOLD;
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Optional.empty();
    }

    @Override
    public String getWikiLink() {
        return null;
    }

    public static boolean checkContains(String command) {
        for (String name : RANDOM_RUN_NAMES) {
            if (!command.contains(name + " ")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String extractSelectionCount(String command) {
        for (String name : RANDOM_RUN_NAMES) {
            String[] parts;
            if (!command.contains(name + " ") || (parts = command.split(name + " ")).length <= 1) continue;
            String selectionPart = parts[1].trim();
            int firstDoublePoint = selectionPart.indexOf(":");
            if (firstDoublePoint != -1 && selectionPart.contains("selectionCount:")) {
                selectionPart = selectionPart.substring(firstDoublePoint + 1).trim();
            }
            return selectionPart.trim();
        }
        return null;
    }
}

