/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.container;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureForBlock;
import com.ssomar.score.features.FeatureForBlockArgs;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListStringFeature;
import com.ssomar.score.utils.emums.ResetSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class ContainerContent
extends ListStringFeature
implements FeatureForItem,
FeatureForBlock {
    private static final boolean DEBUG = true;

    public ContainerContent(FeatureParentInterface parent, List<String> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, defaultValue, featureSettings, Optional.empty());
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v20v5Plus();
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForBlockArgs args) {
        return args.getBlockState() instanceof Container;
    }

    @Override
    public void applyOnBlockData(final @NotNull FeatureForBlockArgs args) {
        BukkitRunnable runnable = new BukkitRunnable(this){
            final /* synthetic */ ContainerContent this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.this$0.getValues().isEmpty() || !this.this$0.isAvailable() || !this.this$0.isApplicable(args)) {
                    SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the value is not present or the meta is not a BlockStateMeta", true);
                    return;
                }
                BlockState blockState = args.getBlockState().getBlock().getState();
                if (!(blockState instanceof Container)) {
                    SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the meta is not a BlockStateMeta", true);
                    return;
                }
                Container container = (Container)blockState;
                try {
                    Inventory inv = container.getInventory();
                    for (String value : this.this$0.getValues()) {
                        String[] split = value.split(";");
                        int slot = Integer.parseInt(split[0].split(":")[1]);
                        String itemString = value.substring(value.indexOf(";") + 1);
                        int amount = 1;
                        if (itemString.contains(";amount:")) {
                            amount = Integer.parseInt(itemString.split(";amount:")[1]);
                            itemString = itemString.split(";amount:")[0];
                        }
                        ItemStack item = Bukkit.getServer().getItemFactory().createItemStack(itemString);
                        item.setAmount(amount);
                        SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the item " + item, true);
                        if (slot >= inv.getSize()) {
                            SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the slot is too big", true);
                            continue;
                        }
                        inv.setItem(slot, item);
                    }
                    SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the blockState is updated", true);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        };
        SCore.schedulerHook.runLocationTask((Runnable)runnable, args.getBlockState().getLocation(), 1L);
    }

    @Override
    public void loadFromBlockData(@NotNull FeatureForBlockArgs args) {
        BlockData blockData = args.getData();
        SsomarDev.testMsg("ItemContainerFeature loadFromBlockData: " + blockData, true);
        ArrayList<String> values = new ArrayList<String>();
        if (this.isAvailable() && this.isApplicable(args)) {
            BlockState blockState = args.getBlockState();
            Container container = (Container)blockState;
            int slot = -1;
            for (ItemStack item : container.getInventory().getContents()) {
                ++slot;
                if (item == null) continue;
                String value = "";
                value = "slot:" + slot + ";minecraft:" + item.getType().toString().toLowerCase() + item.getItemMeta().getAsComponentString() + ";amount:" + item.getAmount();
                SsomarDev.testMsg("ItemContainerFeature loadFromBlockData: the item meta " + value, true);
                values.add(value);
            }
            SsomarDev.testMsg("ItemContainerFeature loadFromBlockData: the blockState loading finish ", true);
            this.setValues(values);
        } else {
            SsomarDev.testMsg("ItemContainerFeature loadFromBlockData: the meta is not a BlockStateMeta", true);
        }
    }

    @Override
    public boolean isApplicable(FeatureForItemArgs args) {
        return args.getMeta() instanceof BlockStateMeta;
    }

    @Override
    public void applyOnItemMeta(FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: " + meta, true);
        if (this.getValues().isEmpty() || !this.isAvailable() || !this.isApplicable(args)) {
            SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the value is not present or the meta is not a BlockStateMeta", true);
            return;
        }
        BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
        if (this.getValues().isEmpty() && !blockStateMeta.hasBlockState()) {
            SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the meta has no blockData", true);
            return;
        }
        if (!(blockStateMeta.getBlockState() instanceof Container)) {
            SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the meta has no blockData", true);
            return;
        }
        Container container = (Container)blockStateMeta.getBlockState();
        try {
            Inventory inv = container.getInventory();
            for (String value : this.getValues()) {
                String[] split = value.split(";");
                if (split.length == 0) {
                    SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the value is not valid " + value, true);
                    continue;
                }
                int slot = Integer.parseInt(split[0].split(":")[1]);
                String itemString = value.substring(value.indexOf(";") + 1);
                int amount = 1;
                if (itemString.contains(";amount:")) {
                    amount = Integer.parseInt(itemString.split(";amount:")[1]);
                    itemString = itemString.split(";amount:")[0];
                }
                SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the itemString " + itemString, true);
                ItemStack item = Bukkit.getServer().getItemFactory().createItemStack(itemString);
                item.setAmount(amount);
                SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the item " + item, true);
                if (slot >= inv.getSize()) {
                    SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the slot is too big", true);
                    continue;
                }
                inv.setItem(slot, item);
            }
            SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the blockState is updated", true);
            container.update();
            blockStateMeta.setBlockState((BlockState)container);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadFromItemMeta(FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        SsomarDev.testMsg("ItemContainerFeature loadFromItemMeta: " + meta, true);
        ArrayList<String> values = new ArrayList<String>();
        if (this.isAvailable() && this.isApplicable(args)) {
            BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
            if (!blockStateMeta.hasBlockState()) {
                SsomarDev.testMsg("ItemContainerFeature loadFromItemMeta: the meta has no blockData", true);
                return;
            }
            BlockState blockState = blockStateMeta.getBlockState();
            Container container = (Container)blockState;
            int slot = -1;
            for (ItemStack item : container.getInventory().getContents()) {
                ++slot;
                if (item == null) continue;
                String value = "";
                value = "slot:" + slot + ";minecraft:" + item.getType().toString().toLowerCase() + item.getItemMeta().getAsComponentString() + ";amount:" + item.getAmount();
                SsomarDev.testMsg("ItemContainerFeature loadFromItemMeta: the item meta " + value, true);
                values.add(value);
            }
            SsomarDev.testMsg("ItemContainerFeature loadFromItemMeta: the blockState loading finish ", true);
            this.setValues(values);
        } else {
            SsomarDev.testMsg("ItemContainerFeature loadFromItemMeta: the meta is not a BlockStateMeta", true);
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.CONTAINER;
    }

    @Override
    public ContainerContent clone(FeatureParentInterface newParent) {
        ContainerContent clone = new ContainerContent(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setValues(this.getValues());
        return clone;
    }
}

