/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public class LocationFeature
extends FeatureAbstract<Optional<Location>, LocationFeature> {
    private Optional<Location> value;
    private Optional<Location> defaultValue;

    public LocationFeature(FeatureParentInterface parent, Optional<Location> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        Location location = config.getLocation(this.getName(), null);
        this.value = location == null ? this.defaultValue : Optional.of(location);
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(location -> config.set(this.getName(), location));
    }

    @Override
    public Optional<Location> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public LocationFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public LocationFeature clone(FeatureParentInterface newParent) {
        LocationFeature clone = new LocationFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Generated
    public Optional<Location> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<Location> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<Location> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

