/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ShapeType;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShapeTypeFeature
extends FeatureAbstract<Optional<ShapeType>, ShapeTypeFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<ShapeType> value;
    private Optional<ShapeType> defaultValue;

    public ShapeTypeFeature(FeatureParentInterface parent, Optional<ShapeType> defaultValue, FeatureSettingsInterface settings) {
        super(parent, settings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        if (colorStr.equals("NULL")) {
            if (this.defaultValue.isPresent()) {
                this.value = this.defaultValue;
            } else {
                errors.add("&cERROR, Couldn't load the ShapeType value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> MATCH_SHAPE, SHAPELESS");
                this.value = Optional.empty();
            }
            return errors;
        }
        try {
            ShapeType attributeSlot = ShapeType.valueOf(colorStr);
            this.value = Optional.ofNullable(attributeSlot);
            FeatureReturnCheckPremium<ShapeType> checkPremium = this.checkPremium("ShapeType", attributeSlot, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            errors.add("&cERROR, Couldn't load the ShapeType value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> MATCH_SHAPE, SHAPELESS");
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(type -> config.set(this.getName(), (Object)type.name()));
    }

    @Override
    public Optional<ShapeType> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public ShapeTypeFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        ShapeType finalValue = ((Optional)value).orElse(ShapeType.MATCH_SHAPE);
        this.updateShapeType(finalValue, gui);
    }

    @Override
    public ShapeTypeFeature clone(FeatureParentInterface newParent) {
        ShapeTypeFeature clone = new ShapeTypeFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateShapeType(this.nextCreationType(this.getRecipeType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateShapeType(this.prevCreationType(this.getRecipeType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public ShapeType nextCreationType(ShapeType slot) {
        boolean next = false;
        for (ShapeType check : this.getSortShapeTypes()) {
            if (check.equals((Object)slot)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortShapeTypes().get(0);
    }

    public ShapeType prevCreationType(ShapeType slot) {
        int i = -1;
        int cpt = 0;
        for (ShapeType check : this.getSortShapeTypes()) {
            if (check.equals((Object)slot)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortShapeTypes().get(this.getSortShapeTypes().size() - 1);
        }
        return this.getSortShapeTypes().get(cpt - 1);
    }

    public void updateShapeType(ShapeType slot, GUI gui) {
        this.value = Optional.of(slot);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortShapeTypes().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (ShapeType check : this.getSortShapeTypes()) {
            if (slot.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + slot.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (ShapeType check : this.getSortShapeTypes()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        for (HumanEntity e : gui.getInv().getViewers()) {
            if (!(e instanceof Player)) continue;
            Player p = (Player)e;
            p.updateInventory();
        }
    }

    public ShapeType getRecipeType(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return ShapeType.valueOf(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<ShapeType> getSortShapeTypes() {
        TreeMap<String, ShapeType> map = new TreeMap<String, ShapeType>();
        for (ShapeType l : ShapeType.values()) {
            map.put(l.name(), l);
        }
        return new ArrayList<ShapeType>(map.values());
    }

    @Generated
    public Optional<ShapeType> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<ShapeType> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<ShapeType> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

