/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.pack.http;

import com.ssomar.score.pack.api.Injector;
import com.ssomar.score.pack.api.InjectorContext;
import com.ssomar.score.pack.api.PacketDirection;
import com.ssomar.score.pack.http.HttpByteBuf;
import com.ssomar.score.pack.http.HttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class HttpInjector
extends Injector {
    private static final List<String> REQUEST_METHODS = Arrays.asList("GET ", "POST ", "PUT ", "DELETE ", "PATCH ");
    private final Logger logger = LoggerFactory.getLogger((String)("HttpInjector " + ((Object)((Object)this)).hashCode()));

    public abstract HttpByteBuf intercept(ChannelHandlerContext var1, HttpRequest var2);

    public boolean isRelevant(InjectorContext ctx, HttpRequest request) {
        return true;
    }

    @Override
    public final boolean isRelevant(InjectorContext ctx, PacketDirection direction) {
        HttpRequest request;
        ByteBuf byteBuf = ctx.getMessage();
        if (!this.isHttp(byteBuf)) {
            return false;
        }
        try {
            request = HttpRequest.parse(byteBuf);
        }
        catch (IOException exception) {
            this.logger.error("failed parsing HTTP request: {}", (Object)exception.getMessage());
            return false;
        }
        return this.isRelevant(ctx, request);
    }

    @Override
    public boolean onRead(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
        HttpRequest request = HttpRequest.parse(buf);
        HttpByteBuf response = this.intercept(ctx, request);
        if (response == null) {
            return false;
        }
        ctx.writeAndFlush((Object)response.inner()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE).addListener(future -> {
            Throwable cause = future.cause();
            if (cause == null) {
                this.logger.debug("Write successful");
            } else {
                this.logger.error("Write failed: {}", (Object)String.valueOf(cause));
                cause.printStackTrace();
            }
        });
        return true;
    }

    private boolean isRequestMethod(ByteBuf buf, String method) {
        for (int i = 0; i < method.length(); ++i) {
            short byteAt;
            char charAt = method.charAt(i);
            if (charAt == (byteAt = buf.getUnsignedByte(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isHttp(ByteBuf buf) {
        for (String methodType : REQUEST_METHODS) {
            if (!this.isRequestMethod(buf, methodType)) continue;
            return true;
        }
        return false;
    }
}

