/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.sobject;

import com.ssomar.score.SCore;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.events.SObjectLoadEvent;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.logging.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public abstract class SObjectManager<T extends SObject> {
    private SPlugin sPlugin;
    private List<T> loadedObjects;
    private List<T> defaultObjects;
    private List<T> allObjects;
    private String objectName;

    public SObjectManager(SPlugin sPlugin) {
        this.sPlugin = sPlugin;
        this.allObjects = new ArrayList<T>();
        this.defaultObjects = new ArrayList<T>();
        this.loadedObjects = new ArrayList<T>();
        this.objectName = "OBJECT";
    }

    public SObjectManager(SPlugin sPlugin, String objectName) {
        this.sPlugin = sPlugin;
        this.allObjects = new ArrayList<T>();
        this.defaultObjects = new ArrayList<T>();
        this.loadedObjects = new ArrayList<T>();
        this.objectName = objectName;
    }

    public void addLoadedObject(T object) {
        this.addLoadedObject(object, true);
    }

    public void addLoadedObject(T object, boolean generateLoadEvent) {
        this.loadedObjects.add(object);
        this.actionOnObjectWhenLoading(object);
        if (generateLoadEvent) {
            this.generateLoadEvent(((SObject)object).getId(), object);
        }
        this.allObjects = new ArrayList<T>();
        this.allObjects.addAll(this.defaultObjects);
        this.allObjects.addAll(this.loadedObjects);
    }

    public void addLoadedObjects(List<T> object) {
        this.addLoadedObjects(object, true);
    }

    public void addLoadedObjects(List<T> object, boolean generateLoadEvent) {
        this.loadedObjects.addAll(object);
        for (SObject o : object) {
            this.actionOnObjectWhenLoading(o);
            if (!generateLoadEvent) continue;
            this.generateLoadEvent(o.getId(), o);
        }
        this.allObjects = new ArrayList<T>();
        this.allObjects.addAll(this.defaultObjects);
        this.allObjects.addAll(this.loadedObjects);
    }

    public abstract void actionOnObjectWhenLoading(T var1);

    public void addDefaultLoadedObject(T object) {
        this.defaultObjects.add(object);
        this.actionOnObjectWhenLoading(object);
        this.generateLoadEvent(((SObject)object).getId(), object);
        this.allObjects = new ArrayList<T>();
        this.allObjects.addAll(this.defaultObjects);
        this.allObjects.addAll(this.loadedObjects);
    }

    public void generateLoadEvent(final String id, T object) {
        Runnable runnable = new Runnable(){
            final /* synthetic */ SObject val$object;
            final /* synthetic */ SObjectManager this$0;
            {
                this.val$object = sObject;
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                SObjectLoadEvent event = new SObjectLoadEvent(id, this.val$object);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
            }
        };
        SCore.schedulerHook.runTask(runnable, 0L);
    }

    public Optional<T> getDefaultObjectWithID(String ID) {
        for (SObject o : this.defaultObjects) {
            if (!o.getId().equals(ID)) continue;
            return Optional.ofNullable(o);
        }
        return Optional.ofNullable(null);
    }

    public Optional<T> getLoadedObjectWithID(String ID) {
        for (SObject o : this.allObjects) {
            if (!o.getId().equals(ID)) continue;
            return Optional.ofNullable(o);
        }
        return Optional.ofNullable(null);
    }

    public List<String> getLoadedObjectsIDs() {
        ArrayList<String> ids = new ArrayList<String>();
        for (SObject o : this.allObjects) {
            ids.add(o.getId());
        }
        return ids;
    }

    public void reloadObject(String id) {
        Optional<T> loadedObject = this.getLoadedObjectWithID(id);
        if (loadedObject.isPresent()) {
            SObject o = (SObject)loadedObject.get();
            this.actionOnObjectWhenReloading(o);
            this.allObjects.remove(o);
            this.loadedObjects.remove(o);
        }
        Utils.sendConsoleMsg(this.sPlugin.getNameDesign() + " &7reloading of &e" + id);
        Optional<T> oOpt = this.methodObjectLoading(id);
        if (oOpt.isPresent()) {
            this.addLoadedObject((SObject)oOpt.get());
        } else {
            this.sPlugin.getPlugin().getServer().getLogger().severe(this.sPlugin.getNameDesign() + " Error when trying to reload the item " + id);
        }
    }

    public void reloadObject(@NotNull T replacement) {
        Optional<T> loadedObject = this.getLoadedObjectWithID(((SObject)replacement).getId());
        if (loadedObject.isPresent()) {
            SObject o = (SObject)loadedObject.get();
            this.actionOnObjectWhenReloading(o);
            this.allObjects.remove(o);
            this.loadedObjects.remove(o);
        }
        Utils.sendConsoleMsg(this.sPlugin.getNameDesign() + " &7reloading of &e" + ((SObject)replacement).getId());
        this.addLoadedObject(replacement);
    }

    public void deleteObject(String id) {
        Optional<T> loadedObject = this.getLoadedObjectWithID(id);
        if (loadedObject.isPresent()) {
            SObject o = (SObject)loadedObject.get();
            this.actionOnObjectWhenReloading(o);
            this.allObjects.remove(o);
            this.loadedObjects.remove(o);
            o.delete();
        }
    }

    public void deleteAllLoadedObjects() {
        while (!this.loadedObjects.isEmpty()) {
            SObject o = (SObject)this.loadedObjects.get(0);
            this.deleteObject(o.getId());
        }
    }

    public void saveAllLoadedObjects() {
        for (SObject o : this.loadedObjects) {
            o.save();
        }
    }

    public abstract void actionOnObjectWhenReloading(T var1);

    public abstract Optional<T> methodObjectLoading(String var1);

    public List<T> getObjects() {
        return this.getAllObjects();
    }

    public List<T> getObjects(Comparator<T> comparator, List<Predicate<T>> predicates) {
        Stream stream = this.getObjects().stream();
        for (Predicate<T> predicate : predicates) {
            stream = stream.filter(predicate);
        }
        return stream.sorted(comparator).collect(Collectors.toList());
    }

    public Optional<T> getObject(String id) {
        return this.getLoadedObjectWithID(id);
    }

    public List<String> getLoadedObjectsWith(String str) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (!str.isEmpty()) {
            for (SObject item : this.getLoadedObjects()) {
                if (!item.getId().toUpperCase().contains(str.toUpperCase())) continue;
                arguments.add(item.getId());
            }
        } else {
            for (SObject item : this.getLoadedObjects()) {
                arguments.add(item.getId());
            }
        }
        return arguments;
    }

    @Generated
    public SPlugin getSPlugin() {
        return this.sPlugin;
    }

    @Generated
    public List<T> getLoadedObjects() {
        return this.loadedObjects;
    }

    @Generated
    public List<T> getDefaultObjects() {
        return this.defaultObjects;
    }

    @Generated
    public List<T> getAllObjects() {
        return this.allObjects;
    }

    @Generated
    public String getObjectName() {
        return this.objectName;
    }

    @Generated
    public void setSPlugin(SPlugin sPlugin) {
        this.sPlugin = sPlugin;
    }

    @Generated
    public void setLoadedObjects(List<T> loadedObjects) {
        this.loadedObjects = loadedObjects;
    }

    @Generated
    public void setDefaultObjects(List<T> defaultObjects) {
        this.defaultObjects = defaultObjects;
    }

    @Generated
    public void setAllObjects(List<T> allObjects) {
        this.allObjects = allObjects;
    }

    @Generated
    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }
}

