/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.sobject;

import com.google.common.io.ByteStreams;
import com.ssomar.score.SCore;
import com.ssomar.score.sobject.SObjectManager;
import com.ssomar.score.sobject.SObjectWithFile;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.logging.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import lombok.Generated;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class SObjectWithFileLoader<T extends SObjectWithFile> {
    private final SPlugin sPlugin;
    private final String defaultObjectsPath;
    private final String defaultObjectsPathWithoutSlash;
    private final SObjectManager<T> sObjectManager;
    private final int maxFreeObjects;
    private final Logger logger;
    private Map<String, String> randomIdsDefaultObjects;
    private int cpt;
    private String objectName;

    public SObjectWithFileLoader(SPlugin sPlugin, String defaultObjectsPath, SObjectWithFileManager<T> sObjectManager, int maxFreeObjects) {
        this.sPlugin = sPlugin;
        this.logger = sPlugin.getPlugin().getServer().getLogger();
        this.defaultObjectsPath = defaultObjectsPath;
        this.defaultObjectsPathWithoutSlash = defaultObjectsPath.startsWith("/") ? defaultObjectsPath.substring(1) : defaultObjectsPath;
        this.sObjectManager = sObjectManager;
        sObjectManager.setFileLoader(this);
        this.maxFreeObjects = maxFreeObjects;
        this.cpt = 0;
        this.objectName = sPlugin.getObjectName();
        if (this.objectName == null) {
            this.objectName = sObjectManager.getObjectName();
        }
        this.objectName = this.objectName.toLowerCase();
    }

    public static File searchFileOfObjectInFolder(String id, File folder) {
        List<String> listFiles = Arrays.asList(folder.list());
        Collections.sort(listFiles);
        for (String s : listFiles) {
            String currentId;
            File fileEntry = new File(folder + "/" + s);
            if (fileEntry.isDirectory()) {
                File result = null;
                result = SObjectWithFileLoader.searchFileOfObjectInFolder(id, fileEntry);
                if (result == null) continue;
                return result;
            }
            if (!fileEntry.getName().contains(".yml") || fileEntry.getName().contains(".txt") || fileEntry.getName().equals(".yml") || !id.equals(currentId = fileEntry.getName().split(".yml")[0])) continue;
            return fileEntry;
        }
        return null;
    }

    public abstract void load();

    public void createDefaultObjectsFile(Boolean isPremiumLoading) {
        this.createDefaultObjectsFile(isPremiumLoading, false);
    }

    public List<String> getObjectsShortPath() {
        ArrayList<String> list;
        block10: {
            list = new ArrayList<String>();
            if (this.defaultObjectsPath.isEmpty()) {
                Utils.sendConsoleMsg(this.sPlugin.getNameDesign() + " &cNo default &6" + this.objectName.toUpperCase() + "&c found in &6" + this.defaultObjectsPath);
                return list;
            }
            try {
                String defaultObjectsPathWithoutFirstSlash = this.defaultObjectsPath.startsWith("/") ? this.defaultObjectsPath.substring(1) : this.defaultObjectsPath;
                Enumeration<URL> resources = this.sPlugin.getClass().getClassLoader().getResources(defaultObjectsPathWithoutFirstSlash);
                ArrayList<URL> urls = Collections.list(resources);
                if (urls.isEmpty()) {
                    Utils.sendConsoleMsg(this.sPlugin.getNameDesign() + " &cNo resources found at path: &6" + defaultObjectsPathWithoutFirstSlash);
                    return list;
                }
                URL resource = (URL)urls.get(0);
                if (!resource.getProtocol().equals("jar")) break block10;
                String path = resource.getPath();
                String jarPath = path.substring(5, path.indexOf("!"));
                String decodedPath = URLDecoder.decode(jarPath, "UTF-8");
                File file = new File(decodedPath);
                try (JarFile jarFile = new JarFile(file);){
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith(defaultObjectsPathWithoutFirstSlash) || entry.isDirectory()) continue;
                        list.add(entry.getName().replace(defaultObjectsPathWithoutFirstSlash, ""));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public void createDefaultObjectsFile(Boolean isPremiumLoading, boolean exists) {
        if (!exists) {
            Utils.sendConsoleMsg(this.sPlugin.getNameDesign() + " &cCANT LOAD YOUR &6" + this.objectName.toUpperCase() + "&c, FOLDER '" + this.objectName + "' not found !");
            Utils.sendConsoleMsg(this.sPlugin.getNameDesign() + " &7It will generate &e" + this.getObjectsShortPath().size() + "&7 default " + this.objectName + " from jar :&e " + this.defaultObjectsPath);
            File fileFolder = new File(this.getConfigsPath());
            fileFolder.mkdirs();
        }
        for (String id : this.getObjectsShortPath()) {
            this.copyDefaultFile(this.defaultObjectsPath + id, this.defaultObjectsPathWithoutSlash, isPremiumLoading);
        }
        Utils.sendConsoleMsg(this.sPlugin.getNameDesign() + " &7DEFAULT &6" + this.objectName.toUpperCase() + "&7 CREATED !");
    }

    public void copyDefaultFile(String pathFile, String defaultPath, Boolean isPremiumLoading) {
        String value = pathFile.replace(defaultPath, "");
        String id = value.substring(value.lastIndexOf("/") + 1);
        if (!isPremiumLoading.booleanValue() && !id.startsWith("Free")) {
            return;
        }
        if (id.contains("_v1_")) {
            String version = id.split("_v1_")[1];
            String minVersion = "1_" + version.split("__")[0];
            String maxVersion = "";
            if (version.contains("__")) {
                maxVersion = version.split("__")[1];
            }
            if (!SCore.isVersionBetween(minVersion, maxVersion)) {
                return;
            }
        }
        try {
            File pdfile = new File(this.getConfigsPath() + "/" + value);
            InputStream in = this.getClass().getResourceAsStream(pathFile);
            if (pdfile.exists()) {
                return;
            }
            this.sPlugin.getPlugin().getDataFolder().mkdirs();
            pdfile.getParentFile().mkdirs();
            pdfile.createNewFile();
            FileOutputStream out = new FileOutputStream(pdfile);
            byte[] buffer = new byte[1024];
            int current = 0;
            while ((current = in.read(buffer)) > -1) {
                ((OutputStream)out).write(buffer, 0, current);
            }
            Utils.sendConsoleMsg(this.sPlugin.getNameDesign() + " &6" + value + " &7was created !");
            ((OutputStream)out).close();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadDefaultPremiumObjects() {
        this.randomIdsDefaultObjects = new HashMap<String, String>();
        for (String value : this.getObjectsShortPath()) {
            String id = value.substring(value.lastIndexOf("/") + 1).replace(".yml", "");
            if (id.startsWith("Free")) continue;
            this.randomIdsDefaultObjects.put(id, UUID.randomUUID().toString());
            InputStream in = this.getClass().getResourceAsStream(this.defaultObjectsPath + value);
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            Optional<T> oOpt = this.getObjectByReader(reader, id, false, this.randomIdsDefaultObjects);
            if (!oOpt.isPresent()) continue;
            SObjectWithFile o = (SObjectWithFile)oOpt.get();
            o.setId(this.randomIdsDefaultObjects.get(o.getId()));
            this.sObjectManager.addDefaultLoadedObject(o);
        }
    }

    public void loadDefaultEncodedPremiumObjects(Map<String, List<String>> defaultObjectsName) {
        if (this.randomIdsDefaultObjects == null) {
            this.randomIdsDefaultObjects = new HashMap<String, String>();
        }
        for (String folder : defaultObjectsName.keySet()) {
            for (String id : defaultObjectsName.get(folder)) {
                this.randomIdsDefaultObjects.put(id, UUID.randomUUID().toString());
            }
        }
        for (String folder : defaultObjectsName.keySet()) {
            for (String id : defaultObjectsName.get(folder)) {
                InputStream in = this.getClass().getResourceAsStream(this.defaultObjectsPath + folder + "/" + id + ".pack");
                ByteArrayInputStream decodedIn = null;
                int length = -1;
                try {
                    length = in.available();
                    byte[] fileBytes = new byte[length];
                    in.read(fileBytes, 0, fileBytes.length);
                    in.close();
                    byte[] decoded = Base64.getDecoder().decode(fileBytes);
                    decodedIn = new ByteArrayInputStream(decoded);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                BufferedReader reader = null;
                reader = new BufferedReader(new InputStreamReader((InputStream)decodedIn, StandardCharsets.UTF_8));
                Optional<T> oOpt = this.getObjectByReader(reader, id, false, this.randomIdsDefaultObjects);
                if (!oOpt.isPresent()) continue;
                SObjectWithFile o = (SObjectWithFile)oOpt.get();
                o.setId(this.randomIdsDefaultObjects.get(o.getId()));
                this.sObjectManager.addDefaultLoadedObject(o);
            }
        }
    }

    public void loadObjectByFile(String filePath, boolean isPremiumLoading) {
        try {
            File fileEntry = new File(filePath);
            String fileName = fileEntry.getName();
            if (!fileName.contains(".yml") || fileName.contains(".txt") || fileName.equals(".yml")) {
                return;
            }
            String id = fileName.split(".yml")[0];
            if (!isPremiumLoading && this.cpt >= this.maxFreeObjects) {
                Utils.sendConsoleMsg(this.sPlugin.getNameDesign() + " &cERROR, REQUIRE PREMIUM: to add more than " + this.maxFreeObjects + " " + this.objectName + " you need the premium version");
                return;
            }
            Optional<T> oOpt = this.getObjectByFile(fileEntry, id, true);
            if (!oOpt.isPresent()) {
                Utils.sendConsoleMsg(this.sPlugin.getNameDesign() + " &cERROR, the file " + filePath + " can't be loaded !");
                return;
            }
            this.sObjectManager.addLoadedObject((SObjectWithFile)oOpt.get());
            ++this.cpt;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadObjectsInFolder(File folder, boolean isPremiumLoading) {
        List<String> listFiles = Arrays.asList(folder.list());
        Collections.sort(listFiles);
        for (String s : listFiles) {
            String folderPath = folder.getPath();
            File fileEntry = new File(folderPath + "/" + s);
            if (fileEntry.isDirectory()) {
                this.loadObjectsInFolder(fileEntry, isPremiumLoading);
                continue;
            }
            this.loadObjectByFile(folderPath + "/" + s, isPremiumLoading);
        }
    }

    public List<String> getAllFoldersName() {
        List<String> listFiles = Arrays.asList(new File(this.getConfigsPath()).list());
        Collections.sort(listFiles);
        ArrayList<String> foldersName = new ArrayList<String>();
        for (String s : listFiles) {
            File fileEntry = new File(this.getConfigsPath() + "/" + s);
            if (!fileEntry.isDirectory()) continue;
            foldersName.add(s);
        }
        return foldersName;
    }

    public List<String> getObjectsNameInFolder(File folder) {
        List<String> listFiles = Arrays.asList(folder.list());
        Collections.sort(listFiles);
        ArrayList<String> objectsName = new ArrayList<String>();
        for (String s : listFiles) {
            File fileEntry = new File(folder.getPath() + "/" + s);
            if (fileEntry.isDirectory()) {
                objectsName.addAll(this.getObjectsNameInFolder(fileEntry));
                continue;
            }
            if (!fileEntry.getName().contains(".yml")) continue;
            String currentId = fileEntry.getName().split(".yml")[0];
            objectsName.add(currentId);
        }
        return objectsName;
    }

    public File searchFileOfObject(String id) {
        List<String> listFiles = Arrays.asList(new File(this.getConfigsPath()).list());
        Collections.sort(listFiles);
        for (String s : listFiles) {
            String currentId;
            File fileEntry = new File(this.getConfigsPath() + "/" + s);
            if (fileEntry.isDirectory()) {
                File result = null;
                result = SObjectWithFileLoader.searchFileOfObjectInFolder(id, fileEntry);
                if (result == null) continue;
                return result;
            }
            if (!fileEntry.getName().contains(".yml") || fileEntry.getName().contains(".txt") || !id.equals(currentId = fileEntry.getName().split(".yml")[0])) continue;
            return fileEntry;
        }
        return null;
    }

    public File searchFolder(String folderName) {
        return this.searchFolder(new File(this.getConfigsPath()), folderName);
    }

    public File searchFolder(File folder, String folderName) {
        if (folder == null || !folder.isDirectory()) {
            return null;
        }
        List<String> listFiles = Arrays.asList(folder.list());
        Collections.sort(listFiles);
        for (String s : listFiles) {
            File fileEntry = new File(this.getConfigsPath() + "/" + s);
            if (!fileEntry.isDirectory()) continue;
            if (fileEntry.getName().equals(folderName)) {
                return fileEntry;
            }
            File result = null;
            result = this.searchFolder(fileEntry, folderName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Optional<T> getObjectByFile(File file, String id, boolean showError) {
        try {
            if (this.CreateBackupFilIfNotValid(file)) {
                return Optional.empty();
            }
            this.configVersionsConverter(file);
            YamlConfiguration objectConfig = YamlConfiguration.loadConfiguration((File)file);
            return this.getObject(file, (FileConfiguration)objectConfig, id, showError);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public Optional<T> getObjectByReader(Reader reader, String id, boolean showError, Map<String, String> wordsToReplace) {
        try {
            YamlConfiguration firstConfig = YamlConfiguration.loadConfiguration((Reader)reader);
            String toStr = firstConfig.saveToString();
            for (String word : wordsToReplace.keySet()) {
                toStr = toStr.replaceAll(word, wordsToReplace.get(word));
            }
            YamlConfiguration config = new YamlConfiguration();
            config.loadFromString(toStr);
            return this.getDefaultObject((FileConfiguration)config, id, showError);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public abstract void configVersionsConverter(File var1);

    public Optional<T> getObjectById(String id, boolean showError) {
        return this.getObjectByFile(this.searchFileOfObject(id), id, showError);
    }

    public Optional<T> getObject(File file, FileConfiguration objectConfig, String id, boolean showError) {
        return this.getObject(objectConfig, id, showError, !this.sPlugin.isLotOfWork(), file.getPath());
    }

    public Optional<T> getObject(FileConfiguration objectConfig, String id, boolean showError) {
        return this.getObject(objectConfig, id, showError, !this.sPlugin.isLotOfWork(), this.searchFileOfObject(id).getPath());
    }

    public Optional<T> getDefaultObject(FileConfiguration objectConfig, String id, boolean showError) {
        return this.getObject(objectConfig, id, showError, true, "");
    }

    public abstract Optional<T> getObject(FileConfiguration var1, String var2, boolean var3, boolean var4, String var5);

    public boolean CreateBackupFilIfNotValid(File file) {
        YamlConfiguration loader = new YamlConfiguration();
        try {
            loader.load(file);
            YamlConfiguration config = loader;
            return false;
        }
        catch (Exception e) {
            this.sPlugin.getPlugin().getLogger().severe("Error when loading " + file.getName() + ", your config is not made correctly ! this website can help you to resolve your problem: https://codebeautify.org/yaml-validator ");
            File fileBackup = new File(file.getParent() + "/" + file.getName() + ".txt");
            int i = 1;
            while (fileBackup.exists()) {
                fileBackup = new File(file.getParent() + "/" + file.getName() + i + ".txt");
                ++i;
            }
            if (!fileBackup.exists()) {
                try {
                    fileBackup.getParentFile().mkdir();
                    fileBackup.createNewFile();
                    FileInputStream is = new FileInputStream(file);
                    FileOutputStream os = new FileOutputStream(fileBackup);
                    ByteStreams.copy((InputStream)is, (OutputStream)os);
                    ((InputStream)is).close();
                    ((OutputStream)os).close();
                }
                catch (Exception e2) {
                    throw new RuntimeException("Unable to create the backup file: " + file.getName(), e2);
                }
            }
            return true;
        }
    }

    public List<String> getAllObjects() {
        ArrayList<String> result = new ArrayList<String>();
        if (new File(this.getConfigsPath()).exists()) {
            List<String> listFiles = Arrays.asList(new File(this.getConfigsPath()).list());
            Collections.sort(listFiles);
            for (String s : listFiles) {
                File fileEntry = new File(this.getConfigsPath() + "/" + s);
                if (fileEntry.isDirectory()) {
                    result.addAll(this.getAllObjectsOfFolder(fileEntry));
                    continue;
                }
                if (!fileEntry.getName().contains(".yml")) continue;
                String id = fileEntry.getName().split(".yml")[0];
                result.add(id);
            }
        }
        return result;
    }

    public List<String> getAllObjectsLowerCases() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.getAllObjects()) {
            result.add(s.toLowerCase());
        }
        return result;
    }

    public List<String> getAllObjectsOfFolder(File folder) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> listFiles = Arrays.asList(folder.list());
        Collections.sort(listFiles);
        for (String s : listFiles) {
            File fileEntry = new File(folder + "/" + s);
            if (fileEntry.isDirectory()) {
                result.addAll(this.getAllObjectsOfFolder(fileEntry));
                continue;
            }
            if (!fileEntry.getName().contains(".yml")) continue;
            String id = fileEntry.getName().split(".yml")[0];
            result.add(id);
        }
        return result;
    }

    public void reload() {
        this.load();
    }

    public boolean reloadFolder(String folderName) {
        File folder = this.searchFolder(folderName);
        if (folder == null) {
            return false;
        }
        List<String> listFiles = this.getObjectsNameInFolder(folder);
        for (String s : listFiles) {
            this.sObjectManager.reloadObject(s);
        }
        return true;
    }

    public List<T> getAllLoadedObjectsOfFolder(String folderName) {
        ArrayList result = new ArrayList();
        File folder = this.searchFolder(folderName);
        if (folder == null) {
            return result;
        }
        List<String> listFiles = this.getObjectsNameInFolder(folder);
        for (String s : listFiles) {
            this.sObjectManager.getLoadedObjectWithID(s).ifPresent(result::add);
        }
        return result;
    }

    public void resetCpt() {
        this.cpt = 0;
    }

    public String getConfigsPath() {
        return this.sPlugin.getPlugin().getDataFolder() + "/" + this.objectName + "/";
    }

    @Generated
    public int getMaxFreeObjects() {
        return this.maxFreeObjects;
    }

    @Generated
    public Map<String, String> getRandomIdsDefaultObjects() {
        return this.randomIdsDefaultObjects;
    }

    @Generated
    public int getCpt() {
        return this.cpt;
    }
}

