/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.usedapi;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.lists.Flags;

public class BentoBoxAPI {
    public static boolean playerIsOnHisIsland(Player player) {
        return BentoBoxAPI.playerIsOnHisIsland(player.getUniqueId(), player.getLocation());
    }

    public static boolean playerIsOnHisIsland(@NotNull UUID pUUID, @NotNull Location location) {
        return BentoBox.getInstance().getIslandsManager().getIslandAt(location).map(island -> island.getMemberSet().contains((Object)pUUID)).orElse(false);
    }

    public static boolean playerCanBreakIslandBlock(@NotNull UUID pUUID, @NotNull Location location) {
        return !BentoBox.getInstance().getIWM().inWorld(location.getWorld()) || BentoBox.getInstance().getIslandsManager().getIslandAt(location).map(island -> island.isAllowed(User.getInstance((UUID)pUUID), Flags.BREAK_BLOCKS)).orElse(Flags.BREAK_BLOCKS.isSetForWorld(location.getWorld())) != false;
    }

    public static boolean playerCanPlaceIslandBlock(@NotNull UUID pUUID, @NotNull Location location) {
        return !BentoBox.getInstance().getIWM().inWorld(location.getWorld()) || BentoBox.getInstance().getIslandsManager().getIslandAt(location).map(island -> island.isAllowed(User.getInstance((UUID)pUUID), Flags.PLACE_BLOCKS)).orElse(Flags.PLACE_BLOCKS.isSetForWorld(location.getWorld())) != false;
    }

    public static boolean playerCanOpenIslandBlock(@NotNull UUID pUUID, @NotNull Location location) {
        return !BentoBox.getInstance().getIWM().inWorld(location.getWorld()) || BentoBox.getInstance().getIslandsManager().getIslandAt(location).map(island -> island.isAllowed(User.getInstance((UUID)pUUID), Flags.CONTAINER)).orElse(Flags.CONTAINER.isSetForWorld(location.getWorld())) != false;
    }

    public static World getWorld(String worldStr) {
        for (World w : BentoBox.getInstance().getIWM().getWorlds()) {
            if (!w.getName().equalsIgnoreCase(worldStr)) continue;
            return w;
        }
        return null;
    }

    public static List<String> getWorlds() {
        ArrayList<String> worlds = new ArrayList<String>();
        for (World w : BentoBox.getInstance().getIWM().getWorlds()) {
            worlds.add(w.getName());
        }
        return worlds;
    }

    public static List<World> getWorldsCB() {
        ArrayList<World> worlds = new ArrayList<World>();
        worlds.addAll(BentoBox.getInstance().getIWM().getWorlds());
        return worlds;
    }
}

