/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.utils.ToolsListMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class PlantInSquare
extends BlockCommand {
    @Override
    public void run(Player p, @NotNull Block block, SCommandToExec sCommandToExec) {
        int slot;
        List<Material> acceptedBlocks;
        Material determineMode;
        List<String> args = sCommandToExec.getOtherArgs();
        int radius = Integer.parseInt(args.get(0));
        boolean takeFromInventory = true;
        if (args.size() > 1) {
            takeFromInventory = Boolean.parseBoolean(args.get(1));
        }
        boolean accepteEI = false;
        if (args.size() > 2) {
            accepteEI = Boolean.parseBoolean(args.get(2));
        }
        List<Object> cropTypes = new ArrayList();
        if (args.size() > 3) {
            cropTypes = Arrays.asList(args.get(3).toUpperCase().split(","));
        }
        if ((determineMode = block.getType()) == Material.FARMLAND) {
            acceptedBlocks = ToolsListMaterial.getInstance().getPlantWithGrowthOnlyFarmland();
        } else if (determineMode == Material.SOUL_SAND) {
            acceptedBlocks = ToolsListMaterial.getInstance().getPlantWithGrowthOnlySoulSand();
        } else {
            SsomarDev.testMsg(ChatColor.RED + "The block is not a farmland or a soul sand, its a " + block.getType(), true);
            return;
        }
        int resourcesNeeded = (radius * 2 + 1) * (radius * 2 + 1);
        if (radius == 0) {
            resourcesNeeded = 1;
        }
        ArrayList<Material> validMaterial = new ArrayList<Material>();
        for (Material cropMaterial : acceptedBlocks) {
            if (!cropTypes.isEmpty() && !cropTypes.contains(cropMaterial.toString())) continue;
            validMaterial.add(ToolsListMaterial.getInstance().getRealMaterialOfBlock(cropMaterial));
        }
        HashMap<Integer, ItemStack> resources = new HashMap<Integer, ItemStack>();
        if (takeFromInventory) {
            slot = 0;
            for (ItemStack item : p.getInventory().getContents()) {
                if (item != null && validMaterial.contains(item.getType()) && (accepteEI || !new ExecutableItemObject(item).isValid())) {
                    resources.put(slot, item);
                    resourcesNeeded -= item.getAmount();
                }
                if (resourcesNeeded > 0) {
                    ++slot;
                    continue;
                }
                break;
            }
        } else {
            slot = 0;
            while (resourcesNeeded > 0) {
                int randomIndex = new Random().nextInt(validMaterial.size());
                Material randomMaterial = (Material)validMaterial.get(randomIndex);
                ItemStack item = new ItemStack(randomMaterial);
                int randomAmount = new Random().nextInt(64);
                item.setAmount(randomAmount);
                resources.put(slot, item);
                resourcesNeeded -= randomAmount;
                ++slot;
            }
        }
        if (!resources.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (ItemStack item : resources.values()) {
                sb.append(item.getAmount()).append(" ").append(item.getType().toString()).append(", ");
            }
            SsomarDev.testMsg(ChatColor.GREEN + "Resources: " + sb.toString(), true);
        }
        if (radius == 0) {
            ItemStack item = this.getValidItem(resources);
            if (item == null) {
                return;
            }
            this.plant(determineMode, block, item);
        }
        for (int x = -radius; x < radius + 1; ++x) {
            ItemStack item;
            for (int z = -radius; z < radius + 1 && (item = this.getValidItem(resources)) != null; ++z) {
                Block farm = block.getWorld().getBlockAt(block.getX() + x, block.getY(), block.getZ() + z);
                this.plant(determineMode, farm, item);
            }
        }
        if (takeFromInventory) {
            PlayerInventory inv = p.getInventory();
            Iterator iterator = resources.keySet().iterator();
            while (iterator.hasNext()) {
                int s = (Integer)iterator.next();
                inv.setItem(s, (ItemStack)resources.get(s));
            }
        }
    }

    public void plant(Material mode, Block farm, ItemStack item) {
        Block toPlant;
        if (farm.getType() == mode && (toPlant = farm.getWorld().getBlockAt(farm.getX(), farm.getY() + 1, farm.getZ())).isEmpty()) {
            toPlant.setType(ToolsListMaterial.getInstance().getBlockMaterialOfItem(item.getType()));
            item.setAmount(item.getAmount() - 1);
        }
    }

    public ItemStack getValidItem(Map<Integer, ItemStack> disposal) {
        for (ItemStack item : disposal.values()) {
            if (item.getAmount() <= 0) continue;
            return item;
        }
        return null;
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        if (args.size() < 1) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + this.getTemplate());
        }
        ArgumentChecker ac = PlantInSquare.checkInteger(args.get(0), isFinalVerification, this.getTemplate());
        if (!ac.isValid()) {
            return Optional.of(ac.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("PLANT_IN_SQUARE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "PLANT_IN_SQUARE {radius} [takeFromInv] [acceptEI] [cropType]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

