/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.particles.commands.XParticle;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Dash
extends MixedCommand {
    public Dash() {
        CommandSetting power = new CommandSetting("power", -1, Double.class, (Object)1);
        CommandSetting pitch = new CommandSetting("pitch", -1, Double.class, (Object)-1);
        CommandSetting yaw = new CommandSetting("yaw", -1, Double.class, (Object)-1);
        List<CommandSetting> settings = this.getSettings();
        settings.add(power);
        settings.add(pitch);
        settings.add(yaw);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Entity receiver, SCommandToExec sCommandToExec) {
        double power = (Double)sCommandToExec.getSettingValue("power");
        double pitch = (Double)sCommandToExec.getSettingValue("pitch");
        double yaw = (Double)sCommandToExec.getSettingValue("yaw");
        Location loc = receiver.getLocation();
        if (pitch == -1.0) {
            pitch = loc.getPitch();
        }
        if (yaw == -1.0) {
            yaw = loc.getYaw();
        }
        Vector direction = XParticle.calculDirection(yaw, pitch).multiply(power);
        receiver.setVelocity(direction);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("DASH");
        return names;
    }

    @Override
    public String getTemplate() {
        return "DASH pitch:-1 yaw:-1 power:2";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

