/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;

public class SetArmorTrim
extends PlayerCommand {
    public SetArmorTrim() {
        CommandSetting slot = new CommandSetting("slot", 0, Integer.class, (Object)-1);
        slot.setSlot(true);
        CommandSetting pattern = new CommandSetting("pattern", 1, String.class, (Object)"sentry");
        CommandSetting patternMaterial = new CommandSetting("patternMaterial", 2, String.class, (Object)"emerald");
        List<CommandSetting> settings = this.getSettings();
        settings.add(slot);
        settings.add(pattern);
        settings.add(patternMaterial);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        ItemMeta itemmeta;
        String pattern = (String)sCommandToExec.getSettingValue("pattern");
        String patternMaterial = (String)sCommandToExec.getSettingValue("patternMaterial");
        int slot = (Integer)sCommandToExec.getSettingValue("slot");
        ItemStack item = slot == -1 ? receiver.getInventory().getItemInMainHand() : receiver.getInventory().getItem(slot);
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (!item.hasItemMeta()) {
            item.setItemMeta(new ItemStack(item.getType()).getItemMeta());
        }
        if ((itemmeta = item.getItemMeta()) instanceof ArmorMeta) {
            ArmorMeta armor = (ArmorMeta)itemmeta;
            if (pattern.equalsIgnoreCase("remove") || pattern.equalsIgnoreCase("null")) {
                armor.setTrim(null);
                item.setItemMeta(itemmeta);
                return;
            }
            TrimPattern trimPattern = this.getTrimPattern(pattern.toLowerCase());
            if (trimPattern == null) {
                return;
            }
            TrimMaterial trimMaterial = this.getTrimMaterial(patternMaterial.toLowerCase());
            if (trimMaterial == null) {
                return;
            }
            ArmorTrim armorTrim = new ArmorTrim(trimMaterial, trimPattern);
            try {
                armor.setTrim(armorTrim);
                item.setItemMeta(itemmeta);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private TrimMaterial getTrimMaterial(String str) {
        return (TrimMaterial)Registry.TRIM_MATERIAL.get(NamespacedKey.minecraft((String)str));
    }

    private TrimPattern getTrimPattern(String str) {
        return (TrimPattern)Registry.TRIM_PATTERN.get(NamespacedKey.minecraft((String)str));
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SET_ARMOR_TRIM");
        names.add("SETARMORTRIM");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SET_ARMOR_TRIM slot:-1 pattern:sentry patternMaterial:emerald";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

