/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.required.magic.magic;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.required.RequiredPlayerInterface;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.willfp.ecoskills.api.EcoSkillsAPI;
import com.willfp.ecoskills.magic.MagicType;
import com.willfp.ecoskills.magic.MagicTypes;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RequiredMagicFeature
extends FeatureWithHisOwnEditor<RequiredMagicFeature, RequiredMagicFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements RequiredPlayerInterface {
    private UncoloredStringFeature magic;
    private IntegerFeature amount;
    private String id;

    public RequiredMagicFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.requiredMagic);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.magic = new UncoloredStringFeature(this, Optional.empty(), FeatureSettingsSCore.magicID, false);
        this.amount = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.amount);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.magic.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.amount.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the Required ExecutableItem because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.magic.save(attributeConfig);
        this.amount.save(attributeConfig);
    }

    @Override
    public RequiredMagicFeature getValue() {
        return this;
    }

    @Override
    public RequiredMagicFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = GUI.CLICK_HERE_TO_CHANGE;
        ItemStack item = new ItemStack(Material.STONE);
        finalDescription[finalDescription.length - 2] = ((Optional)this.magic.getValue()).isPresent() ? "&7&oMagic ID: &a" + (String)((Optional)this.magic.getValue()).get() : "&7&oMagic ID: &cNone";
        finalDescription[finalDescription.length - 1] = "&7Amount: &e" + ((Optional)this.amount.getValue()).get();
        gui.createItem(item, 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public RequiredMagicFeature clone(FeatureParentInterface newParent) {
        RequiredMagicFeature eF = new RequiredMagicFeature(newParent, this.id);
        eF.setMagic(this.magic.clone(eF));
        eF.setAmount(this.amount.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.magic, this.amount));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            RequiredMagicFeature aFOF;
            if (!(feature instanceof RequiredMagicFeature) || !(aFOF = (RequiredMagicFeature)feature).getId().equals(this.id)) continue;
            aFOF.setMagic(this.magic);
            aFOF.setAmount(this.amount);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean verify(Player player, Event event, StringPlaceholder sp) {
        int needed = this.amount.getValue(player.getUniqueId(), sp).get();
        if (!SCore.hasEcoSkills) {
            return true;
        }
        if (!((Optional)this.magic.getValue()).isPresent()) {
            return true;
        }
        String magicId = (String)((Optional)this.magic.getValue()).get();
        MagicType type = (MagicType)MagicTypes.INSTANCE.getByID(magicId);
        int magicAmount = EcoSkillsAPI.getMagic((Player)player, (MagicType)type);
        return magicAmount >= needed;
    }

    @Override
    public void take(Player player, StringPlaceholder sp) {
        int needed = this.amount.getValue(player.getUniqueId(), sp).get();
        if (!SCore.hasEcoSkills) {
            return;
        }
        if (!((Optional)this.magic.getValue()).isPresent()) {
            return;
        }
        String magicId = (String)((Optional)this.magic.getValue()).get();
        MagicType type = (MagicType)MagicTypes.INSTANCE.getByID(magicId);
        int magicAmount = EcoSkillsAPI.getMagic((Player)player, (MagicType)type);
        if (magicAmount < needed) {
            return;
        }
        EcoSkillsAPI.setMagic((Player)player, (MagicType)type, (int)(magicAmount - needed));
    }

    @Generated
    public UncoloredStringFeature getMagic() {
        return this.magic;
    }

    @Generated
    public IntegerFeature getAmount() {
        return this.amount;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setMagic(UncoloredStringFeature magic) {
        this.magic = magic;
    }

    @Generated
    public void setAmount(IntegerFeature amount) {
        this.amount = amount;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

