/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.VariableUpdateType;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class VariableUpdateTypeFeature
extends FeatureAbstract<Optional<VariableUpdateType>, VariableUpdateTypeFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<VariableUpdateType> value;
    private Optional<VariableUpdateType> defaultValue;

    public VariableUpdateTypeFeature(FeatureParentInterface parent, Optional<VariableUpdateType> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        if (colorStr.equals("NULL")) {
            this.value = this.defaultValue;
        } else {
            try {
                VariableUpdateType material = VariableUpdateType.valueOf(colorStr);
                this.value = Optional.ofNullable(material);
                FeatureReturnCheckPremium<VariableUpdateType> checkPremium = this.checkPremium("VariableUpdate Type", material, this.defaultValue, isPremiumLoading);
                if (checkPremium.isHasError()) {
                    this.value = Optional.of(checkPremium.getNewValue());
                }
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load theVariableUpdateType value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> VariableUpdateType available: SET, MODIFICATION");
                this.value = Optional.empty();
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(variableUpdateType -> config.set(this.getName(), (Object)variableUpdateType.name()));
    }

    @Override
    public Optional<VariableUpdateType> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public VariableUpdateTypeFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        VariableUpdateType finalValue = ((Optional)value).orElse(VariableUpdateType.MODIFICATION);
        this.updateVariableUpdateType(finalValue, gui);
    }

    @Override
    public VariableUpdateTypeFeature clone(FeatureParentInterface newParent) {
        VariableUpdateTypeFeature clone = new VariableUpdateTypeFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateVariableUpdateType(this.nextVariableUpdateType(this.getVariableUpdateType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateVariableUpdateType(this.prevVariableUpdateType(this.getVariableUpdateType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public VariableUpdateType nextVariableUpdateType(VariableUpdateType material) {
        boolean next = false;
        for (VariableUpdateType check : this.getSortVariableUpdateTypes()) {
            if (check.equals((Object)material)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortVariableUpdateTypes().get(0);
    }

    public VariableUpdateType prevVariableUpdateType(VariableUpdateType material) {
        int i = -1;
        int cpt = 0;
        for (VariableUpdateType check : this.getSortVariableUpdateTypes()) {
            if (check.equals((Object)material)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortVariableUpdateTypes().get(this.getSortVariableUpdateTypes().size() - 1);
        }
        return this.getSortVariableUpdateTypes().get(cpt - 1);
    }

    public void updateVariableUpdateType(VariableUpdateType typeTarget, GUI gui) {
        this.value = Optional.of(typeTarget);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortVariableUpdateTypes().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (VariableUpdateType check : this.getSortVariableUpdateTypes()) {
            if (typeTarget.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + typeTarget.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (VariableUpdateType check : this.getSortVariableUpdateTypes()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public VariableUpdateType getVariableUpdateType(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return VariableUpdateType.valueOf(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<VariableUpdateType> getSortVariableUpdateTypes() {
        TreeMap<String, VariableUpdateType> map = new TreeMap<String, VariableUpdateType>();
        for (VariableUpdateType l : VariableUpdateType.values()) {
            map.put(l.name(), l);
        }
        return new ArrayList<VariableUpdateType>(map.values());
    }

    @Generated
    public Optional<VariableUpdateType> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<VariableUpdateType> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<VariableUpdateType> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

