/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class ListWeatherFeature
extends ListFeatureAbstract<String, ListWeatherFeature> {
    public ListWeatherFeature(FeatureParentInterface parent, List<String> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, "List of Weather", defaultValue, featureSettings);
        this.reset();
    }

    @Override
    public List<String> loadValues(List<String> entries, List<String> errors) {
        ArrayList<String> value = new ArrayList<String>();
        for (String w : entries) {
            if (this.isValidWeather(w.toUpperCase())) {
                value.add(w.toUpperCase());
                continue;
            }
            errors.add("&cERROR, Couldn't load the Weather value of " + this.getName() + " from config, value: " + w + " &7&o" + this.getParent().getParentInfo() + " &6>> Weather available: RAIN, CLEAR, STORM");
        }
        return value;
    }

    @Override
    public String transfromToString(String value) {
        return value;
    }

    public boolean isValidWeather(String value) {
        ArrayList<String> weathers = new ArrayList<String>();
        weathers.add("RAIN");
        weathers.add("STORM");
        weathers.add("CLEAR");
        return weathers.contains(value);
    }

    @Override
    public ListWeatherFeature clone(FeatureParentInterface newParent) {
        ListWeatherFeature clone = new ListWeatherFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        message = message.toUpperCase();
        if (this.isValidWeather(message = StringConverter.decoloredString(message))) {
            return Optional.empty();
        }
        return Optional.of("&4&l[ERROR] &cThe message you entered is not a weather. &7RAIN, CLEAR or STORM");
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        suggestions.add(new Suggestion("RAIN", "&bRain", "&7Add &bRain"));
        suggestions.add(new Suggestion("CLEAR", "&aClear", "&7Add &aClear"));
        suggestions.add(new Suggestion("STORM", "&8Storm", "&7Add &8Storm"));
        return suggestions;
    }

    @Override
    public String getTips() {
        return "";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, false, false, true, true, false, true, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }
}

